/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;

public class CharactersTest
extends TestCase {
    public CharactersTest(String testName) {
        super(testName);
    }

    public void testCharacters() throws Exception {
        this.useReaderForTesting(0);
        this.useReaderForTesting(1);
        this.useReaderForTesting(512);
        this.useReaderForTesting(1025);
        this.useReaderForTesting(8192);
        this.useReaderForTesting(8193);
        this.useReaderForTesting(10000);
    }

    private void useReaderForTesting(int len) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("<a>");
        for (int i = 0; i < len; ++i) {
            builder.append('a');
        }
        builder.append("</a>");
        String str = builder.toString();
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        XMLStreamBuffer xsb = XMLStreamBuffer.createNewBufferFromXMLStreamReader(rdr);
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        rdr.next();
        xsbrdr.next();
        rdr.next();
        xsbrdr.next();
        if (rdr.hasText()) {
            rdr.getTextCharacters();
            this.compareCharacters(rdr, (XMLStreamReader)((Object)xsbrdr));
        }
    }

    private void compareCharacters(XMLStreamReader rdr1, XMLStreamReader rdr2) throws Exception {
        char[] buf1 = new char[1024];
        char[] buf2 = new char[1024];
        int start = 0;
        int read1 = buf1.length;
        while (read1 == buf1.length) {
            read1 = rdr1.getTextCharacters(start, buf1, 0, buf1.length);
            int read2 = rdr2.getTextCharacters(start, buf2, 0, buf2.length);
            CharactersTest.assertEquals((int)read1, (int)read2);
            CharactersTest.assertEquals((String)new String(buf1), (String)new String(buf2));
            start += buf1.length;
        }
    }
}

