/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.PGPData;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.content.SPKIData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Logger log = Logger.getLogger(KeyInfo.class.getName());
    List x509Datas = null;
    List encryptedKeys = null;
    static final List nullList;
    List _internalKeyResolvers = null;
    List _storageResolvers = nullList;
    static boolean _alreadyInitialized;

    public KeyInfo(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public void setId(String string) {
        if (string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this._doc, string));
    }

    public void add(KeyName keyName) {
        this._constructionElement.appendChild(keyName.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this._doc, element));
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this._doc, dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this._doc, rSAKeyValue));
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void add(KeyValue keyValue) {
        this._constructionElement.appendChild(keyValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this._doc, string));
    }

    public void add(MgmtData mgmtData) {
        this._constructionElement.appendChild(mgmtData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(PGPData pGPData) {
        this._constructionElement.appendChild(pGPData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this._doc, string, transforms, string2));
    }

    public void add(RetrievalMethod retrievalMethod) {
        this._constructionElement.appendChild(retrievalMethod.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(SPKIData sPKIData) {
        this._constructionElement.appendChild(sPKIData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(X509Data x509Data) {
        if (this.x509Datas == null) {
            this.x509Datas = new ArrayList();
        }
        this.x509Datas.add(x509Data);
        this._constructionElement.appendChild(x509Data.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this.encryptedKeys == null) {
            this.encryptedKeys = new ArrayList();
        }
        this.encryptedKeys.add(encryptedKey);
        XMLCipher xMLCipher = XMLCipher.getInstance();
        this._constructionElement.appendChild(xMLCipher.martial(encryptedKey));
    }

    public void addUnknownElement(Element element) {
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        if (this.x509Datas != null) {
            return this.x509Datas.size();
        }
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int n = 0;
        NodeList nodeList = this._constructionElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyName", n);
        if (element != null) {
            return new KeyName(element, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyValue", n);
        if (element != null) {
            return new KeyValue(element, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "MgmtData", n);
        if (element != null) {
            return new MgmtData(element, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "PGPData", n);
        if (element != null) {
            return new PGPData(element, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RetrievalMethod", n);
        if (element != null) {
            return new RetrievalMethod(element, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SPKIData", n);
        if (element != null) {
            return new SPKIData(element, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        if (this.x509Datas != null) {
            return (X509Data)this.x509Datas.get(n);
        }
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Data", n);
        if (element != null) {
            return new X509Data(element, this._baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int n) throws XMLSecurityException {
        if (this.encryptedKeys != null) {
            return (EncryptedKey)this.encryptedKeys.get(n);
        }
        Element element = XMLUtils.selectXencNode(this._constructionElement.getFirstChild(), "EncryptedKey", n);
        if (element != null) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(4, null);
            return xMLCipher.loadEncryptedKey(element);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++n2 != n) continue;
            return (Element)node;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._constructionElement.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            log.log(Level.FINE, "I could find a key using the per-KeyInfo key resolvers");
            return publicKey;
        }
        log.log(Level.FINE, "I couldn't find a key using the per-KeyInfo key resolvers");
        publicKey = this.getPublicKeyFromStaticResolvers();
        if (publicKey != null) {
            log.log(Level.FINE, "I could find a key using the system-wide key resolvers");
            return publicKey;
        }
        log.log(Level.FINE, "I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        int n = KeyResolver.length();
        int n2 = this._storageResolvers.size();
        Iterator iterator = KeyResolver.iterator();
        for (int i = 0; i < n; ++i) {
            KeyResolverSpi keyResolverSpi = (KeyResolverSpi)iterator.next();
            String string = this.getBaseURI();
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (int j = 0; j < n2; ++j) {
                    StorageResolver storageResolver = (StorageResolver)this._storageResolvers.get(j);
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver);
                    if (publicKey == null) continue;
                    KeyResolver.hit(iterator);
                    return publicKey;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        int n = this.lengthInternalKeyResolver();
        int n2 = this._storageResolvers.size();
        for (int i = 0; i < n; ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            String string = this.getBaseURI();
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (int j = 0; j < n2; ++j) {
                    StorageResolver storageResolver = (StorageResolver)this._storageResolvers.get(j);
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver);
                    if (publicKey == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            log.log(Level.FINE, "I could find a X509Certificate using the per-KeyInfo key resolvers");
            return x509Certificate;
        }
        log.log(Level.FINE, "I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        x509Certificate = this.getX509CertificateFromStaticResolvers();
        if (x509Certificate != null) {
            log.log(Level.FINE, "I could find a X509Certificate using the system-wide key resolvers");
            return x509Certificate;
        }
        log.log(Level.FINE, "I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        log.log(Level.FINE, "Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers");
        String string = this.getBaseURI();
        int n = KeyResolver.length();
        int n2 = this._storageResolvers.size();
        Iterator iterator = KeyResolver.iterator();
        for (int i = 0; i < n; ++i) {
            KeyResolverSpi keyResolverSpi = (KeyResolverSpi)iterator.next();
            X509Certificate x509Certificate = this.applyCurrentResolver(string, n2, keyResolverSpi);
            if (x509Certificate == null) continue;
            KeyResolver.hit(iterator);
            return x509Certificate;
        }
        return null;
    }

    private X509Certificate applyCurrentResolver(String string, int n, KeyResolverSpi keyResolverSpi) throws KeyResolverException {
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            for (int i = 0; i < n; ++i) {
                StorageResolver storageResolver = (StorageResolver)this._storageResolvers.get(i);
                X509Certificate x509Certificate = keyResolverSpi.engineLookupResolveX509Certificate((Element)node, string, storageResolver);
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        log.log(Level.FINE, "Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers");
        String string = this.getBaseURI();
        int n = this._storageResolvers.size();
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            X509Certificate x509Certificate = this.applyCurrentResolver(string, n, keyResolverSpi);
            if (x509Certificate == null) continue;
            return x509Certificate;
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey secretKey = this.getSecretKeyFromInternalResolvers();
        if (secretKey != null) {
            log.log(Level.FINE, "I could find a secret key using the per-KeyInfo key resolvers");
            return secretKey;
        }
        log.log(Level.FINE, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        secretKey = this.getSecretKeyFromStaticResolvers();
        if (secretKey != null) {
            log.log(Level.FINE, "I could find a secret key using the system-wide key resolvers");
            return secretKey;
        }
        log.log(Level.FINE, "I couldn't find a secret key using the system-wide key resolvers");
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        int n = KeyResolver.length();
        int n2 = this._storageResolvers.size();
        Iterator iterator = KeyResolver.iterator();
        for (int i = 0; i < n; ++i) {
            KeyResolverSpi keyResolverSpi = (KeyResolverSpi)iterator.next();
            String string = this.getBaseURI();
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (int j = 0; j < n2; ++j) {
                    StorageResolver storageResolver = (StorageResolver)this._storageResolvers.get(j);
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        int n = this._storageResolvers.size();
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            String string = this.getBaseURI();
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (int j = 0; j < n; ++j) {
                    StorageResolver storageResolver = (StorageResolver)this._storageResolvers.get(j);
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        if (this._internalKeyResolvers == null) {
            this._internalKeyResolvers = new ArrayList();
        }
        this._internalKeyResolvers.add(keyResolverSpi);
    }

    int lengthInternalKeyResolver() {
        if (this._internalKeyResolvers == null) {
            return 0;
        }
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return (KeyResolverSpi)this._internalKeyResolvers.get(n);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (this._storageResolvers == nullList) {
            this._storageResolvers = new ArrayList();
        }
        this._storageResolvers.add(storageResolver);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (log == null) {
                log = Logger.getLogger(KeyInfo.class.getName());
                log.log(Level.SEVERE, "Had to assign log in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        nullList = Collections.unmodifiableList(arrayList);
        _alreadyInitialized = false;
    }
}

