/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.streambuffer;

import com.sun.xml.fastinfoset.streambuffer.AccessibleStringBuilder;
import com.sun.xml.fastinfoset.types.LexicalSpaceConvertor;
import com.sun.xml.fastinfoset.types.XSDataType;
import com.sun.xml.stream.buffer.AbstractCreator;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class TypedSAXBufferCreator
extends AbstractCreator
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler {
    protected Map<String, Set<XSDataType>> _elements;
    protected Map<String, Set<XSDataType>> _attributes;
    protected String[] _namespaceAttributes = new String[32];
    protected int _namespaceAttributesPtr;
    protected AccessibleStringBuilder _textContent = new AccessibleStringBuilder();
    protected boolean _storeTextContent;
    protected Set<XSDataType> _textContentTypes;

    public static XMLStreamBuffer create(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes, InputStream in) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return TypedSAXBufferCreator.createNewBufferFromXMLReader(elements, attributes, spf.newSAXParser().getXMLReader(), in);
    }

    public static XMLStreamBuffer createNewBufferFromXMLReader(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes, XMLReader reader, InputStream in) throws SAXException, IOException, ParserConfigurationException {
        return TypedSAXBufferCreator.createNewBufferFromXMLReader(elements, attributes, reader, in, null);
    }

    public static XMLStreamBuffer createNewBufferFromXMLReader(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes, XMLReader reader, InputStream in, String systemId) throws SAXException, IOException, ParserConfigurationException {
        TypedSAXBufferCreator t = new TypedSAXBufferCreator(elements, attributes);
        return t.create(reader, in, systemId);
    }

    public TypedSAXBufferCreator(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes) {
        this._elements = elements;
        this._attributes = attributes;
    }

    public TypedSAXBufferCreator(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes, MutableXMLStreamBuffer buffer) {
        this(elements, attributes);
        this.setBuffer(buffer);
    }

    public MutableXMLStreamBuffer create(XMLReader reader, InputStream in) throws IOException, SAXException {
        return this.create(reader, in, null);
    }

    public MutableXMLStreamBuffer create(XMLReader reader, InputStream in, String systemId) throws IOException, SAXException {
        if (this._buffer == null) {
            this.createBuffer();
        }
        reader.setContentHandler(this);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        try {
            this.setHasInternedStrings(reader.getFeature("http://xml.org/sax/features/string-interning"));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (systemId != null) {
            InputSource s = new InputSource(systemId);
            s.setByteStream(in);
            reader.parse(s);
        } else {
            reader.parse(new InputSource(in));
        }
        return this.getXMLStreamBuffer();
    }

    public void reset() {
        this._buffer = null;
        this._namespaceAttributesPtr = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.storeStructure(16);
    }

    @Override
    public void endDocument() throws SAXException {
        this.storeStructure(144);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.storeTextContent();
        this.cacheNamespaceAttribute(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.storeTextContent();
        this._textContentTypes = this._elements.get(localName);
        this.storeQualifiedName(32, uri, localName, qName);
        if (this._namespaceAttributesPtr > 0) {
            this.storeNamespaceAttributes();
        }
        if (attributes.getLength() > 0) {
            this.storeAttributes(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.storeTextContent();
        this.storeStructure(144);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._storeTextContent = true;
        this._textContent.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.storeTextContent();
        this.storeStructure(112);
        this.storeStructureString(target);
        this.storeStructureString(data);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.storeTextContent();
        this.storeContentCharacters(96, ch, start, length);
    }

    private void storeTextContent() {
        if (this._storeTextContent) {
            Object o = LexicalSpaceConvertor.convertToValueSpace(this._textContentTypes, this._textContent.getValue(), 0, this._textContent.length(), LexicalSpaceConvertor.LexicalPreference.charArray);
            boolean isCharArray = o instanceof char[];
            if (o != null && !isCharArray) {
                this.storeStructure(92);
                this.storeContentObject(o);
            } else if (isCharArray) {
                char[] ch = (char[])o;
                this.storeContentCharacters(80, ch, 0, ch.length);
            } else {
                this.storeContentCharacters(80, this._textContent.getValue(), 0, this._textContent.length());
            }
            this._textContentTypes = null;
            this._storeTextContent = false;
            this._textContent.setLength(0);
        }
    }

    private void cacheNamespaceAttribute(String prefix, String uri) {
        this._namespaceAttributes[this._namespaceAttributesPtr++] = prefix;
        this._namespaceAttributes[this._namespaceAttributesPtr++] = uri;
        if (this._namespaceAttributesPtr == this._namespaceAttributes.length) {
            String[] namespaceAttributes = new String[this._namespaceAttributesPtr * 3 / 2 + 1];
            System.arraycopy(this._namespaceAttributes, 0, namespaceAttributes, 0, this._namespaceAttributesPtr);
            this._namespaceAttributes = namespaceAttributes;
        }
    }

    private void storeNamespaceAttributes() {
        for (int i = 0; i < this._namespaceAttributesPtr; i += 2) {
            int item = 64;
            if (this._namespaceAttributes[i].length() > 0) {
                item |= 1;
                this.storeStructureString(this._namespaceAttributes[i]);
            }
            if (this._namespaceAttributes[i + 1].length() > 0) {
                item |= 2;
                this.storeStructureString(this._namespaceAttributes[i + 1]);
            }
            this.storeStructure(item);
        }
        this._namespaceAttributesPtr = 0;
    }

    private void storeAttributes(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value = attributes.getValue(i);
            Object o = LexicalSpaceConvertor.convertToValueSpace(this._attributes.get(attributes.getLocalName(i)), value, LexicalSpaceConvertor.LexicalPreference.string);
            boolean storeAsString = o == null || o instanceof String;
            this.storeQualifiedName(storeAsString ? 48 : 56, attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
            this.storeStructureString(attributes.getType(i));
            if (storeAsString) {
                if (o instanceof String) {
                    this.storeContentString((String)o);
                    continue;
                }
                this.storeContentString(value);
                continue;
            }
            this.storeContentObject(o);
        }
    }

    private void storeQualifiedName(int item, String uri, String localName, String qName) {
        if (uri.length() > 0) {
            item |= 2;
            this.storeStructureString(uri);
        }
        this.storeStructureString(localName);
        if (qName.indexOf(58) >= 0) {
            item |= 4;
            this.storeStructureString(qName);
        }
        this.storeStructure(item);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

