/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.streambuffer;

import com.sun.xml.fastinfoset.types.ValueInstance;
import com.sun.xml.stream.buffer.AbstractCreator;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import java.io.IOException;
import java.io.InputStream;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmContentHandler;
import org.jvnet.fastinfoset.sax.FastInfosetReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public final class FastInfosetReaderSAXBufferCreator
extends AbstractCreator
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler,
EncodingAlgorithmContentHandler {
    protected String[] _namespaceAttributes = new String[32];
    protected int _namespaceAttributesPtr;

    public FastInfosetReaderSAXBufferCreator() {
    }

    public FastInfosetReaderSAXBufferCreator(MutableXMLStreamBuffer buffer) {
        this.setBuffer(buffer);
    }

    public MutableXMLStreamBuffer create(FastInfosetReader reader, InputStream in) throws IOException, SAXException {
        if (this._buffer == null) {
            this.createBuffer();
        }
        reader.setContentHandler((ContentHandler)this);
        reader.setLexicalHandler((LexicalHandler)this);
        reader.setEncodingAlgorithmContentHandler((EncodingAlgorithmContentHandler)this);
        try {
            this.setHasInternedStrings(reader.getFeature("http://xml.org/sax/features/string-interning"));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        reader.parse(new InputSource(in));
        return this.getXMLStreamBuffer();
    }

    public void reset() {
        this._buffer = null;
        this._namespaceAttributesPtr = 0;
    }

    public void startDocument() throws SAXException {
        this.storeStructure(16);
    }

    public void endDocument() throws SAXException {
        this.storeStructure(0);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.cacheNamespaceAttribute(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.storeQualifiedName(32, uri, localName, qName);
        if (this._namespaceAttributesPtr > 0) {
            this.storeNamespaceAttributes();
        }
        if (attributes.getLength() > 0) {
            this.storeAttributes((EncodingAlgorithmAttributes)attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.storeStructure(0);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.storeContentCharacters(80, ch, 0, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.storeStructure(112);
        this.storeStructureString(target);
        this.storeStructureString(data);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.storeContentCharacters(96, ch, start, length);
    }

    public void octets(String URI, int algorithm, byte[] b, int start, int length) throws SAXException {
    }

    public void object(String URI, int algorithm, Object o) throws SAXException {
        this.storeStructure(92);
        this.storeContentObject(algorithm, o);
    }

    private void cacheNamespaceAttribute(String prefix, String uri) {
        this._namespaceAttributes[this._namespaceAttributesPtr++] = prefix;
        this._namespaceAttributes[this._namespaceAttributesPtr++] = uri;
        if (this._namespaceAttributesPtr == this._namespaceAttributes.length) {
            String[] namespaceAttributes = new String[this._namespaceAttributesPtr * 3 / 2 + 1];
            System.arraycopy(this._namespaceAttributes, 0, namespaceAttributes, 0, this._namespaceAttributesPtr);
            this._namespaceAttributes = namespaceAttributes;
        }
    }

    private void storeNamespaceAttributes() {
        for (int i = 0; i < this._namespaceAttributesPtr; i += 2) {
            int item = 64;
            if (this._namespaceAttributes[i].length() > 0) {
                item |= 1;
                this.storeStructureString(this._namespaceAttributes[i]);
            }
            if (this._namespaceAttributes[i + 1].length() > 0) {
                item |= 2;
                this.storeStructureString(this._namespaceAttributes[i + 1]);
            }
            this.storeStructure(item);
        }
        this._namespaceAttributesPtr = 0;
    }

    private void storeAttributes(EncodingAlgorithmAttributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object o = attributes.getAlgorithmData(i);
            this.storeQualifiedName(o == null ? 48 : 56, attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
            this.storeStructureString(attributes.getType(i));
            if (o == null) {
                this.storeContentString(attributes.getValue(i));
                continue;
            }
            this.storeContentObject(attributes.getAlgorithmIndex(i), o);
        }
    }

    private void storeContentObject(int algorithm, Object o) {
        Object previousValue = this.peekAtContentObject();
        if (previousValue != null && previousValue instanceof ValueInstance) {
            ((ValueInstance)previousValue).set(algorithm, o);
            this.storeContentObject(previousValue);
        } else {
            this.storeContentObject(new ValueInstance(algorithm, o));
        }
    }

    private void storeQualifiedName(int item, String uri, String localName, String qName) {
        if (uri.length() > 0) {
            item |= 2;
            this.storeStructureString(uri);
        }
        this.storeStructureString(localName);
        if (qName.indexOf(58) >= 0) {
            item |= 4;
            this.storeStructureString(qName);
        }
        this.storeStructure(item);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

