/*
 * Decompiled with CFR 0.152.
 */
package samples.typed;

import com.sun.xml.fastinfoset.sax.SAXDocumentParser;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import org.jvnet.fastinfoset.sax.PrimitiveTypeContentHandler;
import org.jvnet.fastinfoset.sax.helpers.EncodingAlgorithmAttributesImpl;
import org.jvnet.fastinfoset.sax.helpers.FastInfosetDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PrimitiveTypesWithElementContentSample {
    byte[] createFIDocument() throws SAXException {
        SAXDocumentSerializer fiw = new SAXDocumentSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        fiw.setOutputStream((OutputStream)baos);
        EncodingAlgorithmAttributesImpl atts = new EncodingAlgorithmAttributesImpl();
        fiw.startDocument();
        fiw.startElement("", "root", "root", null);
        byte[] bytes = new byte[]{1, 2, 3, 4};
        atts.clear();
        atts.addAttributeWithBuiltInAlgorithmData("", "value", "value", 1, (Object)bytes);
        fiw.startElement("", "bytes", "bytes", (Attributes)atts);
        fiw.bytes(bytes, 0, bytes.length);
        fiw.endElement("", "bytes", "bytes");
        int[] ints = new int[]{1, 2, 3, 4};
        atts.clear();
        atts.addAttributeWithBuiltInAlgorithmData("", "value", "value", 3, (Object)ints);
        fiw.startElement("", "integers", "integers", (Attributes)atts);
        fiw.ints(ints, 0, ints.length);
        fiw.endElement("", "integers", "integers");
        float[] floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        atts.clear();
        atts.addAttributeWithBuiltInAlgorithmData("", "value", "value", 6, (Object)floats);
        fiw.startElement("", "floats", "floats", (Attributes)atts);
        fiw.floats(floats, 0, floats.length);
        fiw.endElement("", "floats", "floats");
        fiw.endElement("", "root", "root");
        fiw.endDocument();
        return baos.toByteArray();
    }

    void parseFIDocumentUsingPTC(InputStream in) throws Exception {
        SAXDocumentParser r = new SAXDocumentParser();
        FastInfosetHandler h = new FastInfosetHandler();
        r.setContentHandler((ContentHandler)((Object)h));
        r.setPrimitiveTypeContentHandler((PrimitiveTypeContentHandler)h);
        r.parse(in);
    }

    void parseFIDocument(InputStream in) throws Exception {
        SAXDocumentParser r = new SAXDocumentParser();
        CHandler h = new CHandler();
        r.setContentHandler((ContentHandler)h);
        r.parse(in);
    }

    public static void main(String[] args) throws Exception {
        PrimitiveTypesWithElementContentSample pt = new PrimitiveTypesWithElementContentSample();
        byte[] b = pt.createFIDocument();
        pt.parseFIDocumentUsingPTC(new ByteArrayInputStream(b));
        pt.parseFIDocument(new ByteArrayInputStream(b));
    }

    private static class FastInfosetHandler
    extends FastInfosetDefaultHandler {
        private FastInfosetHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes instanceof EncodingAlgorithmAttributes) {
                EncodingAlgorithmAttributes a = (EncodingAlgorithmAttributes)attributes;
                block5: for (int index = 0; index < a.getLength(); ++index) {
                    Object data = a.getAlgorithmData(index);
                    if (data == null) continue;
                    switch (a.getAlgorithmIndex(index)) {
                        case 1: {
                            System.out.print("Attribute value as bytes: ");
                            byte[] bs = (byte[])data;
                            for (int i = 0; i < bs.length; ++i) {
                                if (i > 0) {
                                    System.out.print(" ");
                                }
                                System.out.print(bs[i]);
                            }
                            System.out.println();
                            continue block5;
                        }
                        case 3: {
                            System.out.print("Attribute value as ints: ");
                            int[] is = (int[])data;
                            for (int i = 0; i < is.length; ++i) {
                                if (i > 0) {
                                    System.out.print(" ");
                                }
                                System.out.print(is[i]);
                            }
                            System.out.println();
                            continue block5;
                        }
                        case 6: {
                            System.out.print("Attribute value as floats: ");
                            float[] fs = (float[])data;
                            for (int i = 0; i < fs.length; ++i) {
                                if (i > 0) {
                                    System.out.print(" ");
                                }
                                System.out.print(fs[i]);
                            }
                            System.out.println();
                            continue block5;
                        }
                    }
                }
            }
        }

        public void bytes(byte[] bs, int start, int length) throws SAXException {
            System.out.print("element content as bytes: ");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(bs[start + i]);
            }
            System.out.println();
        }

        public void ints(int[] is, int start, int length) throws SAXException {
            System.out.print("element content as ints: ");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(is[start + i]);
            }
            System.out.println();
        }

        public void floats(float[] fs, int start, int length) throws SAXException {
            System.out.print("element content as floats: ");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(fs[start + i]);
            }
            System.out.println();
        }
    }

    private static class CHandler
    extends DefaultHandler {
        private CHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            for (int index = 0; index < attributes.getLength(); ++index) {
                System.out.println("attribute value as text: " + attributes.getValue(index));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            System.out.println("element content as text: " + s);
        }
    }
}

