/*
 * Decompiled with CFR 0.152.
 */
package samples.typed;

import com.sun.xml.analysis.types.SchemaProcessor;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.fastinfoset.sax.SAXDocumentParser;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.types.XSDataType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.jvnet.fastinfoset.FastInfosetSource;
import org.jvnet.fastinfoset.sax.PrimitiveTypeContentHandler;
import org.jvnet.fastinfoset.sax.helpers.EncodingAlgorithmAttributesImpl;
import org.jvnet.fastinfoset.sax.helpers.FastInfosetDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ConvertLexicalValues {
    public static void main(String[] args) throws Exception {
        SchemaProcessor sp = new SchemaProcessor(new File(args[0]).toURI().toURL());
        sp.process();
        SAXDocumentSerializer s = new SAXDocumentSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        s.setOutputStream((OutputStream)baos);
        LexicalFilter lf = new LexicalFilter(sp.getElementToXSDataTypeMap(), sp.getAttributeToXSDataTypeMap());
        lf.setContentHandler((ContentHandler)s);
        lf.setParent(ConvertLexicalValues.getXMLReader());
        lf.parse(new InputSource(new FileInputStream(args[1])));
        FastInfosetSource source = new FastInfosetSource((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        StreamResult result = new StreamResult(System.out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.transform((Source)source, result);
        System.out.println();
        SAXDocumentParser p = new SAXDocumentParser();
        FastInfosetDefaultHandler h = new FastInfosetDefaultHandler(){

            public void bytes(byte[] b, int start, int length) throws SAXException {
                System.out.println("Byte: " + b[start]);
            }

            public void floats(float[] f, int start, int length) throws SAXException {
                System.out.println("Float: " + f[start]);
            }
        };
        p.setContentHandler((ContentHandler)h);
        p.setPrimitiveTypeContentHandler((PrimitiveTypeContentHandler)h);
        p.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public static XMLReader getXMLReader() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return spf.newSAXParser().getXMLReader();
    }

    static class LexicalFilter
    extends XMLFilterImpl {
        private Map<String, Set<XSDataType>> _elements;
        private Map<String, Set<XSDataType>> _attributes;
        private Set<XSDataType> _textContent;

        public LexicalFilter(Map<String, Set<XSDataType>> elements, Map<String, Set<XSDataType>> attributes) {
            this._elements = elements;
            this._attributes = attributes;
        }

        private void replaceAttributeValue(Set<XSDataType> attributeTypes, int index, EncodingAlgorithmAttributesImpl atts) {
            if (attributeTypes == null) {
                return;
            }
            char[] ch = atts.getValue(index).toCharArray();
            for (XSDataType dt : attributeTypes) {
                try {
                    switch (dt) {
                        case BASE64BINARY: {
                            byte[] b = (byte[])BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm.convertFromCharacters(ch, 0, ch.length);
                            atts.replaceWithAttributeAlgorithmData(index, null, 1, (Object)b);
                            return;
                        }
                        case FLOAT: {
                            float[] f = (float[])BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.convertFromCharacters(ch, 0, ch.length);
                            atts.replaceWithAttributeAlgorithmData(index, null, 6, (Object)f);
                            return;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this._textContent = this._elements.get(localName);
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!this._attributes.containsKey(atts.getLocalName(i))) continue;
                EncodingAlgorithmAttributesImpl eatts = new EncodingAlgorithmAttributesImpl(atts);
                for (i = 0; i < atts.getLength(); ++i) {
                    this.replaceAttributeValue(this._attributes.get(atts.getLocalName(i)), i, eatts);
                }
                atts = eatts;
                break;
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this._textContent == null) {
                super.characters(ch, start, length);
                return;
            }
            for (XSDataType dt : this._textContent) {
                try {
                    switch (dt) {
                        case BASE64BINARY: {
                            byte[] b = (byte[])BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm.convertFromCharacters(ch, start, length);
                            ((PrimitiveTypeContentHandler)this.getContentHandler()).bytes(b, 0, b.length);
                            this._textContent = null;
                            return;
                        }
                        case FLOAT: {
                            float[] f = (float[])BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.convertFromCharacters(ch, start, length);
                            ((PrimitiveTypeContentHandler)this.getContentHandler()).floats(f, 0, f.length);
                            this._textContent = null;
                            return;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            super.characters(ch, start, length);
        }
    }
}

