/*
 * Decompiled with CFR 0.152.
 */
package samples.sax;

import com.sun.xml.fastinfoset.sax.SAXDocumentParser;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParsingSample
extends DefaultHandler {
    private static Writer out;
    StringBuffer textBuffer;

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("Usage: FastInfosetParser filename");
            System.exit(1);
        }
        SAXParsingSample handler = new SAXParsingSample();
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(argv[0]));
            SAXDocumentParser parser = new SAXDocumentParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.parse((InputStream)in);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    @Override
    public void startDocument() throws SAXException {
        this.display("<?xml version='1.0' encoding='UTF-8'?>");
        this.displayNewLine();
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.displayNewLine();
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushText();
        String name = localName.isEmpty() ? qName : localName;
        this.display("<" + name);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String aName = attributes.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attributes.getQName(i);
                }
                this.display(" " + aName + "=\"" + attributes.getValue(i) + "\"");
            }
        }
        this.display(">");
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushText();
        String name = localName;
        if ("".equals(name)) {
            name = qName;
        }
        this.display("</" + name + ">");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private void flushText() throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        this.display(this.textBuffer.toString());
        this.textBuffer = null;
    }

    private void display(String s) throws SAXException {
        try {
            out.write(s);
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void displayNewLine() throws SAXException {
        try {
            out.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }
}

