/*
 * Decompiled with CFR 0.152.
 */
package samples.stax;

import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import samples.common.Util;

public class StAXParsingSample {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 1) {
            StAXParsingSample.displayUsageAndExit();
        }
        if (args[0] == null) {
            StAXParsingSample.displayUsageAndExit();
        }
        StAXParsingSample streamReader = new StAXParsingSample();
        streamReader.parse(args[0]);
    }

    public void parse(String filename) {
        StAXDocumentParser streamReader = null;
        try {
            BufferedInputStream document = new BufferedInputStream(new FileInputStream(filename));
            streamReader = new StAXDocumentParser((InputStream)document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Reading " + new File(filename) + ": \n");
        long starttime = System.currentTimeMillis();
        try {
            while (streamReader != null && streamReader.hasNext()) {
                int eventType = streamReader.next();
                Util.printEventType(eventType);
                Util.printName((XMLStreamReader)streamReader, eventType);
                Util.printText((XMLStreamReader)streamReader);
                if (streamReader.isStartElement()) {
                    Util.printAttributes((XMLStreamReader)streamReader);
                }
                Util.printPIData((XMLStreamReader)streamReader);
                System.out.println("-----------------------------");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long endtime = System.currentTimeMillis();
        System.out.println(" Parsing Time = " + (endtime - starttime));
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: ant StreamReader or samples.stax.StreamReader FI_file");
        System.exit(1);
    }
}

