/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.roundtriptests.rtt;

import com.sun.xml.fastinfoset.tools.TransformInputOutput;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class RoundTripRtt {
    protected RoundTripRtt() {
    }

    public abstract boolean process(File var1) throws Exception;

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inputFileName, String outputFileName, TransformInputOutput transformer) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(inputFileName);
            fos = new FileOutputStream(outputFileName);
            transformer.parse((InputStream)fis, (OutputStream)fos);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inputFileName, String outputFileName, String workingDirectory, TransformInputOutput transformer) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(inputFileName);
            fos = new FileOutputStream(outputFileName);
            transformer.parse((InputStream)fis, (OutputStream)fos, workingDirectory);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean diffBinary(String fileName1, String fileName2, String diffFileName) throws IOException {
        PrintWriter diffWriter = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(diffFileName))));
        InputStream file1InputStream = null;
        InputStream file2InputStream = null;
        try {
            File file1 = new File(fileName1);
            File file2 = new File(fileName2);
            file1InputStream = new BufferedInputStream(new FileInputStream(fileName1));
            file2InputStream = new BufferedInputStream(new FileInputStream(fileName2));
            boolean passed = true;
            if (file1.length() != file2.length()) {
                passed = false;
                diffWriter.println("Result FI documents have different size");
            }
            if (file1.length() > file2.length()) {
                InputStream tmpIn = file1InputStream;
                file1InputStream = file2InputStream;
                file2InputStream = tmpIn;
                String tmpName = fileName1;
                fileName1 = fileName2;
                fileName2 = tmpName;
            }
            boolean isFirstWrite = true;
            int byteNumber = 0;
            int ch1 = 0;
            while ((ch1 = file1InputStream.read()) != -1) {
                int ch2 = file2InputStream.read();
                if (ch1 != ch2) {
                    if (isFirstWrite) {
                        diffWriter.println("<offset>: " + fileName1 + " | " + fileName2);
                        isFirstWrite = false;
                    }
                    diffWriter.println(Integer.toHexString(byteNumber) + ": " + Integer.toHexString(ch1) + " " + Integer.toHexString(ch2));
                    passed = false;
                }
                ++byteNumber;
            }
            if (!passed) {
                diffWriter.println("Fast infoset document does not have the same content as the X.finf specification");
            }
            boolean bl = passed;
            return bl;
        }
        finally {
            if (file1InputStream != null) {
                try {
                    file1InputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (file2InputStream != null) {
                try {
                    file2InputStream.close();
                }
                catch (IOException iOException) {}
            }
            diffWriter.flush();
            diffWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean diffText(String fileName1, String fileName2, String diffFileName) throws IOException {
        BufferedReader file1Reader = null;
        BufferedReader file2Reader = null;
        PrintWriter diffWriter = null;
        try {
            file1Reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName1)));
            file2Reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName2)));
            diffWriter = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(diffFileName))));
            boolean passed = true;
            String line1 = null;
            int lineNumber = 1;
            while ((line1 = file1Reader.readLine()) != null) {
                String line2 = file2Reader.readLine();
                if (line2 == null) {
                    passed = false;
                    RoundTripRtt.printHeader1(diffWriter, fileName1, lineNumber);
                    diffWriter.println(line1);
                    diffWriter.println("...............................");
                    RoundTripRtt.printHeader2(diffWriter, fileName2, lineNumber);
                    diffWriter.println("EOF");
                }
                if (!line1.equals(line2)) {
                    passed = false;
                    RoundTripRtt.printHeader1(diffWriter, fileName1, lineNumber);
                    diffWriter.println(line1);
                    RoundTripRtt.printHeader2(diffWriter, fileName2, lineNumber);
                    diffWriter.println(line2);
                }
                ++lineNumber;
            }
            line1 = file2Reader.readLine();
            if (line1 != null) {
                passed = false;
                RoundTripRtt.printHeader1(diffWriter, fileName1, lineNumber);
                diffWriter.println("EOF");
                RoundTripRtt.printHeader2(diffWriter, fileName2, lineNumber);
                diffWriter.println(line1);
                diffWriter.println("...............................");
            }
            boolean bl = passed;
            return bl;
        }
        finally {
            if (file1Reader != null) {
                try {
                    file1Reader.close();
                }
                catch (IOException iOException) {}
            }
            if (file2Reader != null) {
                try {
                    file2Reader.close();
                }
                catch (IOException iOException) {}
            }
            if (diffWriter != null) {
                diffWriter.close();
            }
        }
    }

    private static void printHeader1(PrintWriter resultWriter, String fileName, int lineNumber) {
        resultWriter.println("\\\\\\\\\\\\\\\\\\ " + fileName + ":" + lineNumber + " \\\\\\\\\\\\\\\\\\\\\\");
    }

    private static void printHeader2(PrintWriter resultWriter, String fileName, int lineNumber) {
        resultWriter.println("///////// " + fileName + ":" + lineNumber + " /////////");
    }
}

