/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.roundtriptests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoundTripReport {
    static final int INDEX_HOME = 0;
    static final int INDEX_REPORT = 1;
    static final int INDEX_TESTCASE = 2;
    static final int INDEX_TESTCASEPATH = 3;
    static final int INDEX_TESTNAME = 4;
    static final int INDEX_RESULT = 5;
    static final String COUNT_DEFAULT = "N/A";
    static final String COUNT_SAXPASSED = "<!--saxroundtrip_passed-->";
    static final String COUNT_SAXFAILED = "<!--saxroundtrip_failed-->";
    static final String COUNT_STAXPASSED = "<!--staxroundtrip_passed-->";
    static final String COUNT_STAXFAILED = "<!--staxroundtrip_failed-->";
    static final String COUNT_DOMPASSED = "<!--domroundtrip_passed-->";
    static final String COUNT_DOMFAILED = "<!--domroundtrip_failed-->";
    static final String COUNT_DOMSAXPASSED = "<!--domsaxroundtrip_passed-->";
    static final String COUNT_DOMSAXFAILED = "<!--domsaxroundtrip_failed-->";
    static final String COUNT_SAXSTAXPASSED = "<!--saxstaxdiff_passed-->";
    static final String COUNT_SAXSTAXFAILED = "<!--saxstaxdiff_failed-->";
    static final String RESULT_PASSED = "passed";
    static final String RESULT_FAILED = "failed";
    static final String REPORTCOUNT_TOTAL = "<!--{TOTAL}-->";
    static final String REPORT_NEWROW = "<!--{new row}-->";
    static final String TEST_SAX = "saxroundtrip";
    static final String TEST_STAX = "staxroundtrip";
    static final String TEST_DOM = "domroundtrip";
    static final String TEST_DOMSAX = "domsaxroundtrip";
    static final String TEST_SAXSTAX = "saxstaxdiff";
    static final List<String> RTT_NAMES = new ArrayList<String>(Arrays.asList("saxroundtrip", "staxroundtrip", "domroundtrip", "domsaxroundtrip", "saxstaxdiff"));
    static final int SAX_RTT = 0;
    static final int STAX_RTT = 1;
    static final int DOM_RTT = 2;
    static final int DOM_SAX_RTT = 3;
    static final int SAX_STAX_RTT = 4;
    private final int[] passed = new int[RTT_NAMES.size()];
    private final int[] failed = new int[RTT_NAMES.size()];
    private final Map<String, FailedTestRecord> failedTests = new HashMap<String, FailedTestRecord>();

    public void addResult(String rttName, boolean passed, String testFolder, String testFile) {
        int rttIndex = RTT_NAMES.indexOf(rttName);
        if (rttIndex == -1) {
            return;
        }
        if (passed) {
            this.incPassed(rttIndex);
        } else {
            this.incFailed(rttIndex);
            this.addFailedRecord(testFolder, testFile, rttIndex);
        }
    }

    public String generateReport() {
        return RoundTripReport.generateReport(this.passed, this.failed, this.failedTests);
    }

    private void incPassed(int rtt) {
        int n = rtt;
        this.passed[n] = this.passed[n] + 1;
    }

    private void incFailed(int rtt) {
        int n = rtt;
        this.failed[n] = this.failed[n] + 1;
    }

    private void addFailedRecord(String testPath, String testName, int rtt) {
        String testFullName = testPath + "/" + testName;
        FailedTestRecord failTestRecord = this.failedTests.get(testFullName);
        if (failTestRecord == null) {
            failTestRecord = new FailedTestRecord(testName);
            this.failedTests.put(testFullName, failTestRecord);
        }
        failTestRecord.setFailedFor(rtt);
    }

    public static void main(String[] args) {
        if (args.length != 6) {
            RoundTripReport.displayUsageAndExit(args);
        }
        new RoundTripReport().report(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String[] args) {
        OutputStreamWriter osr = null;
        try {
            String filename = args[0] + "/" + args[1];
            String content = this.reportContent(filename, args);
            osr = new OutputStreamWriter(new FileOutputStream(filename));
            osr.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (osr != null) {
                try {
                    osr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String reportContent(String filename, String[] args) {
        File file = new File(filename);
        StringBuffer content = new StringBuffer();
        if (file.exists()) {
            content.append(this.readFromFile(file));
        } else {
            content.append(this.getTemplate());
        }
        this.countIncrement("<!--" + args[4] + "_" + args[5] + "-->", content);
        int testcaseStart = content.indexOf(args[2]);
        int start = 0;
        int end = 0;
        String newrow = null;
        if (args[5].equals(RESULT_FAILED)) {
            String testname;
            if (testcaseStart < 0) {
                newrow = "<tr><td><a href=" + args[3].substring(args[0].length() + 1) + "/" + args[2] + ">" + args[2] + "</a></td>\n<td><!--saxroundtrip--></td>\n<td><!--staxroundtrip--></td>\n<td><!--domroundtrip--></td>\n<td><!--domsaxroundtrip--></td>\n<td><!--saxstaxdiff--></td></tr>\n<!--{new row}-->\n";
                start = content.indexOf(REPORT_NEWROW);
                end = start + REPORT_NEWROW.length();
                content.replace(start, end, newrow);
                testcaseStart = start;
            }
            if ((start = content.indexOf(testname = "<!--" + args[4] + "-->", testcaseStart)) > 0) {
                end = start + testname.length();
                content.replace(start, end, args[5]);
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFile(File file) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            FileInputStream fstream = new FileInputStream(file);
            in = new BufferedReader(new InputStreamReader(fstream));
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    private boolean countIncrement(String tag, StringBuffer content) {
        try {
            int start = content.indexOf(tag);
            int end = content.indexOf(tag, start + 1);
            Object temp = content.substring(start + tag.length(), end);
            int count = 1;
            if (!((String)temp).equals(COUNT_DEFAULT)) {
                count = Integer.parseInt((String)temp) + 1;
            }
            temp = tag + count + tag;
            content.replace(start, end + tag.length(), (String)temp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getTemplate() {
        return RoundTripReport.generateReport(new int[5], new int[5], Collections.emptyMap());
    }

    private static String generateReport(int[] passed, int[] failed, Map<String, FailedTestRecord> failedTests) {
        StringBuilder report = new StringBuilder();
        report.append("<html>\n<body>\n<b>Roundtrip Tests</b><br><br>");
        report.append("<b>Summary</b>");
        report.append("<table width=\"80%\" border=1>\n");
        report.append("<tr><th></th><th>SAX</th><th>StAX</th><th>DOM</th><th>DOM-SAX</th><th>SAX-StAX</th></tr>\n");
        report.append("<tr><td>Passed</td>\n").append("<td>").append(COUNT_SAXPASSED).append(RoundTripReport.getReportValue(passed[0], failed[0])).append(COUNT_SAXPASSED).append("</td>\n").append("<td>").append(COUNT_STAXPASSED).append(RoundTripReport.getReportValue(passed[1], failed[1])).append(COUNT_STAXPASSED).append("</td>\n").append("<td>").append(COUNT_DOMPASSED).append(RoundTripReport.getReportValue(passed[2], failed[2])).append(COUNT_DOMPASSED).append("</td>\n").append("<td>").append(COUNT_DOMSAXPASSED).append(RoundTripReport.getReportValue(passed[3], failed[3])).append(COUNT_DOMSAXPASSED).append("</td>\n").append("<td>").append(COUNT_SAXSTAXPASSED).append(RoundTripReport.getReportValue(passed[4], failed[4])).append(COUNT_SAXSTAXPASSED).append("</td></tr>\n");
        report.append("<tr><td>Failed</td>\n").append("<td>").append(COUNT_SAXFAILED).append(RoundTripReport.getReportValue(failed[0], passed[0])).append(COUNT_SAXFAILED).append("</td>\n").append("<td>").append(COUNT_STAXFAILED).append(RoundTripReport.getReportValue(failed[1], passed[1])).append(COUNT_STAXFAILED).append("</td>\n").append("<td>").append(COUNT_DOMFAILED).append(RoundTripReport.getReportValue(failed[2], passed[2])).append(COUNT_DOMFAILED).append("</td>\n").append("<td>").append(COUNT_DOMSAXFAILED).append(RoundTripReport.getReportValue(failed[3], passed[3])).append(COUNT_DOMSAXFAILED).append("</td>\n").append("<td>").append(COUNT_SAXSTAXFAILED).append(RoundTripReport.getReportValue(failed[4], passed[4])).append(COUNT_SAXSTAXFAILED).append("</td></tr>\n");
        report.append("<tr><td>Total</td>\n").append("<td>").append(RoundTripReport.getReportValue(failed[0] + passed[0])).append("</td>\n").append("<td>").append(RoundTripReport.getReportValue(failed[1] + passed[1])).append("</td>\n").append("<td>").append(RoundTripReport.getReportValue(failed[2] + passed[2])).append("</td>\n").append("<td>").append(RoundTripReport.getReportValue(failed[3] + passed[3])).append("</td>\n").append("<td>").append(RoundTripReport.getReportValue(failed[4] + passed[4])).append("</td></tr>\n");
        report.append(REPORTCOUNT_TOTAL);
        report.append("</table>\n");
        report.append("<br><b>Failed List</b><br><table width=\"80%\" border=1>\n");
        report.append("<tr><th>Name of Testcase</th><th>SAX</th><th>StAX</th><th>DOM</th><th>DOM-SAX</th><th>SAX-StAX</th></tr>\n");
        for (Map.Entry<String, FailedTestRecord> entry : failedTests.entrySet()) {
            String testFullPath = entry.getKey();
            FailedTestRecord failedRecord = entry.getValue();
            String newrow = "<tr><td><a href=" + testFullPath + ">" + failedRecord.testName + "</a></td>\n<td><!--saxroundtrip-->" + RoundTripReport.getResultAsString(!failedRecord.isFailedFor(0)) + "</td>\n<td><!--staxroundtrip-->" + RoundTripReport.getResultAsString(!failedRecord.isFailedFor(1)) + "</td>\n<td><!--domroundtrip-->" + RoundTripReport.getResultAsString(!failedRecord.isFailedFor(2)) + "</td>\n<td><!--domsaxroundtrip-->" + RoundTripReport.getResultAsString(!failedRecord.isFailedFor(3)) + "</td>\n<td><!--saxstaxdiff-->" + RoundTripReport.getResultAsString(!failedRecord.isFailedFor(4)) + "</td></tr>\n";
            report.append(newrow);
        }
        report.append("<!--{new row}-->\n");
        report.append("</table>\n");
        report.append("</body>\n</html>");
        return report.toString();
    }

    private static String getResultAsString(boolean result) {
        return result ? "" : RESULT_FAILED;
    }

    private static String getReportValue(int value) {
        return RoundTripReport.getReportValue(value, value);
    }

    private static String getReportValue(int value, int oppositeResultValue) {
        return value == 0 && oppositeResultValue == 0 ? COUNT_DEFAULT : String.valueOf(value);
    }

    private static void displayUsageAndExit(String[] args) {
        System.err.println("Usage: RoundTripReport TS_HOME reportPath testcase_filename testcase_path testname testresult");
        System.err.println("Your input:");
        System.err.println("Number of arguments: " + args.length);
        for (int i = 0; i < args.length; ++i) {
            System.err.println("args[" + i + "]=" + args[i]);
        }
        System.err.println("Example: RoundTripReport /projects/fi/RoundTripTests/data xmlts_report.html 011.xml /projects/fi/RoundTripTests/xmltest/valid saxroundtrip failed");
        System.exit(1);
    }

    private static class FailedTestRecord {
        private int rttMap;
        private String testName;

        public FailedTestRecord(String testName) {
            this.testName = testName;
        }

        public boolean isFailedFor(int rtt) {
            return (this.rttMap & 1 << rtt) != 0;
        }

        public void setFailedFor(int rtt) {
            this.rttMap |= 1 << rtt;
        }
    }
}

