/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.roundtriptests;

import com.sun.xml.fastinfoset.roundtriptests.FileUtils;
import com.sun.xml.fastinfoset.roundtriptests.RoundTripReport;
import com.sun.xml.fastinfoset.roundtriptests.rtt.RoundTripRtt;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;

public class SingleRountTripTest {
    private RoundTripReport report;
    private RoundTripRtt test;

    public SingleRountTripTest(RoundTripRtt test, RoundTripReport report) {
        this.test = test;
        this.report = report;
    }

    public void processRtt(File srcFile) {
        boolean passed;
        try {
            System.out.println(this.test.getName() + ": " + srcFile.getAbsolutePath());
            passed = this.test.process(srcFile);
        }
        catch (Exception ex) {
            passed = false;
            System.err.println("Exception occured when processing file: " + srcFile.getAbsolutePath() + " test: " + this.test.getClass().getName());
            ex.printStackTrace();
        }
        String srcFolder = srcFile.getParent() != null ? srcFile.getParent() : ".";
        this.report.addResult(this.test.getName(), passed, srcFolder, srcFile.getName());
        String passedStr = passed ? "passed" : "failed";
        System.out.println(passedStr.toUpperCase(Locale.US));
    }

    public void processFileOrFolder(File srcFile) {
        FileUtils.processFileOrDirectoryRecursivelly(srcFile, new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return !file.getName().equals(".") && !file.getName().equals("..");
                }
                if (file.isFile()) {
                    return file.getName().endsWith(".xml");
                }
                return false;
            }
        }, new FileUtils.FileProcessorHandler(){

            @Override
            public void handle(File file) {
                SingleRountTripTest.this.processRtt(file);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage: SingleRountTripTest <RoundTripRtt classname> <src file or directory> <report_filename>");
            System.exit(0);
        }
        RoundTripReport report = new RoundTripReport();
        new SingleRountTripTest((RoundTripRtt)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]), report).processFileOrFolder(new File(args[1]));
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(args[2])));){
            writer.print(report.generateReport());
        }
    }
}

