/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.roundtriptests;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

public class RoundTripReport {
    static final int INDEX_HOME = 0;
    static final int INDEX_REPORT = 1;
    static final int INDEX_TESTCASE = 2;
    static final int INDEX_TESTCASEPATH = 3;
    static final int INDEX_TESTNAME = 4;
    static final int INDEX_RESULT = 5;
    static final String COUNT_DEFAULT = "N/A";
    static final String COUNT_SAXPASSED = "<!--saxroundtrip_passed-->";
    static final String COUNT_SAXFAILED = "<!--saxroundtrip_failed-->";
    static final String COUNT_STAXPASSED = "<!--staxroundtrip_passed-->";
    static final String COUNT_STAXFAILED = "<!--staxroundtrip_failed-->";
    static final String COUNT_DOMPASSED = "<!--domroundtrip_passed-->";
    static final String COUNT_DOMFAILED = "<!--domroundtrip_failed-->";
    static final String COUNT_DOMSAXPASSED = "<!--domsaxroundtrip_passed-->";
    static final String COUNT_DOMSAXFAILED = "<!--domsaxroundtrip_failed-->";
    static final String COUNT_SAXSTAXPASSED = "<!--saxstaxdiff_passed-->";
    static final String COUNT_SAXSTAXFAILED = "<!--saxstaxdiff_failed-->";
    static final String RESULT_PASSED = "passed";
    static final String RESULT_FAILED = "failed";
    static final String REPORTCOUNT_TOTAL = "<!--{TOTAL}-->";
    static final String REPORT_NEWROW = "<!--{new row}-->";
    static final String TEST_SAX = "saxroundtrip";
    static final String TEST_STAX = "staxroundtrip";
    static final String TEST_DOM = "domroundtrip";
    static final String TEST_DOMSAX = "domsaxroundtrip";
    static final String TEST_SAXSTAX = "saxstaxdiff";

    public static void main(String[] args) {
        if (args.length != 6) {
            RoundTripReport.displayUsageAndExit(args);
        }
        new RoundTripReport().report(args);
    }

    public void report(String[] args) {
        try {
            String filename = args[0] + "/" + args[1];
            String content = this.reportContent(filename, args);
            OutputStreamWriter osr = new OutputStreamWriter(new FileOutputStream(new File(filename)));
            osr.write(content);
            osr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String reportContent(String filename, String[] args) {
        File file = new File(filename);
        StringBuffer content = new StringBuffer();
        if (file.exists()) {
            content.append(this.readFromFile(file));
        } else {
            content.append(this.getTemplate());
        }
        this.countIncrement("<!--" + args[4] + "_" + args[5] + "-->", content);
        int testcaseStart = content.indexOf(args[2]);
        int start = 0;
        int end = 0;
        String newrow = null;
        if (args[5].equals(RESULT_FAILED)) {
            String testname;
            if (testcaseStart < 0) {
                newrow = "<tr><td><a href=" + args[3].substring(args[0].length() + 1) + "/" + args[2] + ">" + args[2] + "</a></td>\n" + "<td><!--" + TEST_SAX + "--></td>\n" + "<td><!--" + TEST_STAX + "--></td>\n" + "<td><!--" + TEST_DOM + "--></td>\n" + "<td><!--" + TEST_DOMSAX + "--></td>\n" + "<td><!--" + TEST_SAXSTAX + "--></td></tr>\n" + REPORT_NEWROW + "\n";
                start = content.indexOf(REPORT_NEWROW);
                end = start + REPORT_NEWROW.length();
                content.replace(start, end, newrow);
                testcaseStart = start;
            }
            if ((start = content.indexOf(testname = "<!--" + args[4] + "-->", testcaseStart)) > 0) {
                end = start + testname.length();
                content.replace(start, end, args[5]);
            }
        }
        return content.toString();
    }

    private String readFromFile(File file) {
        StringBuffer sb = new StringBuffer();
        try {
            FileInputStream fstream = new FileInputStream(file);
            DataInputStream in = new DataInputStream(fstream);
            while (in.available() != 0) {
                sb.append(in.readLine());
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private boolean countIncrement(String tag, StringBuffer content) {
        try {
            int start = content.indexOf(tag);
            int end = content.indexOf(tag, start + 1);
            String temp = content.substring(start + tag.length(), end);
            int count = 1;
            if (!temp.equals(COUNT_DEFAULT)) {
                count = Integer.parseInt(temp) + 1;
            }
            temp = tag + count + tag;
            content.replace(start, end + tag.length(), temp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("<html>\n<body>\n<b>Roundtrip Tests</b><br><br>");
        template.append("<b>Summary</b>");
        template.append("<table width=\"80%\" border=1>\n");
        template.append("<tr><th></th><th>SAX</th><th>StAX</th><th>DOM</th><th>DOM-SAX</th><th>SAX-StAX</th></tr>\n");
        template.append("<tr><td>Passed</td>\n<td><!--saxroundtrip_passed-->N/A<!--saxroundtrip_passed--></td>\n<td><!--staxroundtrip_passed-->N/A<!--staxroundtrip_passed--></td>\n<td><!--domroundtrip_passed-->N/A<!--domroundtrip_passed--></td>\n<td><!--domsaxroundtrip_passed-->N/A<!--domsaxroundtrip_passed--></td>\n<td><!--saxstaxdiff_passed-->N/A<!--saxstaxdiff_passed--></td></tr>\n");
        template.append("<tr><td>Failed</td>\n<td><!--saxroundtrip_failed-->N/A<!--saxroundtrip_failed--></td>\n<td><!--staxroundtrip_failed-->N/A<!--staxroundtrip_failed--></td>\n<td><!--domroundtrip_failed-->N/A<!--domroundtrip_failed--></td>\n<td><!--domsaxroundtrip_failed-->N/A<!--domsaxroundtrip_failed--></td>\n<td><!--saxstaxdiff_failed-->N/A<!--saxstaxdiff_failed--></td></tr>\n");
        template.append("<tr><td>Total</td>\n<td><!--{TOTAL}-->N/A<!--{TOTAL}--></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td></tr>\n");
        template.append(REPORTCOUNT_TOTAL);
        template.append("</table>\n");
        template.append("<br><b>Failed List</b><br><table width=\"80%\" border=1>\n");
        template.append("<tr><th>Name of Testcase</th><th>SAX</th><th>StAX</th><th>DOM</th><th>DOM-SAX</th><th>SAX-StAX</th></tr>\n");
        template.append(REPORT_NEWROW);
        template.append("</table>\n");
        template.append("</body>\n</html>");
        return template.toString();
    }

    private static void displayUsageAndExit(String[] args) {
        System.err.println("Usage: RoundTripReport TS_HOME reportPath testcase_filename testcase_path testname testresult");
        System.err.println("Your input:");
        System.err.println("Number of arguments: " + args.length);
        for (int i = 0; i < args.length; ++i) {
            System.err.println("args[" + i + "]=" + args[i]);
        }
        System.err.println("Example: RoundTripReport /projects/fi/RoundTripTests/data xmlts_report.html 011.xml /projects/fi/RoundTripTests/xmltest/valid saxroundtrip failed");
        System.exit(1);
    }
}

