/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.scd;

import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.impl.scd.AbstractAxisImpl;
import com.sun.xml.xsom.impl.scd.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Axis<T extends XSComponent> {
    public static final Axis<XSSchema> ROOT = new Axis<XSSchema>(){

        @Override
        public Iterator<XSSchema> iterator(XSComponent contextNode) {
            return contextNode.getRoot().iterateSchema();
        }

        @Override
        public Iterator<XSSchema> iterator(Iterator<? extends XSComponent> contextNodes) {
            if (!contextNodes.hasNext()) {
                return Iterators.empty();
            }
            return this.iterator(contextNodes.next());
        }

        @Override
        public boolean isModelGroup() {
            return false;
        }

        public String toString() {
            return "root::";
        }
    };
    public static final Axis<XSComponent> INTERMEDIATE_SKIP = new AbstractAxisImpl<XSComponent>(){

        @Override
        public Iterator<XSComponent> elementDecl(XSElementDecl decl) {
            XSComplexType ct = decl.getType().asComplexType();
            if (ct == null) {
                return this.empty();
            }
            return new Iterators.Union<XSComponent>((Iterator<XSComponent>)this.singleton(ct), (Iterator<XSComponent>)this.complexType(ct));
        }

        @Override
        public Iterator<XSComponent> modelGroupDecl(XSModelGroupDecl decl) {
            return this.descendants(decl.getModelGroup());
        }

        @Override
        public Iterator<XSComponent> particle(XSParticle particle2) {
            return this.descendants(particle2.getTerm().asModelGroup());
        }

        private Iterator<XSComponent> descendants(XSModelGroup mg) {
            ArrayList<XSComponent> r = new ArrayList<XSComponent>();
            this.visit(mg, r);
            return r.iterator();
        }

        private void visit(XSModelGroup mg, List<XSComponent> r) {
            r.add(mg);
            for (XSParticle p : mg) {
                XSModelGroup child = p.getTerm().asModelGroup();
                if (child == null) continue;
                this.visit(child, r);
            }
        }

        public String toString() {
            return "(intermediateSkip)";
        }
    };
    public static final Axis<XSComponent> DESCENDANTS = new Axis<XSComponent>(){

        @Override
        public Iterator<XSComponent> iterator(XSComponent contextNode) {
            return new Visitor().iterator(contextNode);
        }

        @Override
        public Iterator<XSComponent> iterator(Iterator<? extends XSComponent> contextNodes) {
            return new Visitor().iterator(contextNodes);
        }

        @Override
        public boolean isModelGroup() {
            return false;
        }

        public String toString() {
            return "/";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Visitor
        extends AbstractAxisImpl<XSComponent> {
            private final Set<XSComponent> visited = new HashSet<XSComponent>();

            Visitor() {
            }

            @Override
            public Iterator<XSComponent> schema(XSSchema schema) {
                if (this.visited.add(schema)) {
                    return this.ret(schema, new Recursion(schema.iterateElementDecls()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> elementDecl(XSElementDecl decl) {
                if (this.visited.add(decl)) {
                    return this.ret(decl, this.iterator(decl.getType()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> simpleType(XSSimpleType type) {
                if (this.visited.add(type)) {
                    return this.ret(type, FACET.iterator(type));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> complexType(XSComplexType type) {
                if (this.visited.add(type)) {
                    return this.ret(type, this.iterator(type.getContentType()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> particle(XSParticle particle2) {
                if (this.visited.add(particle2)) {
                    return this.ret(particle2, this.iterator(particle2.getTerm()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> modelGroupDecl(XSModelGroupDecl decl) {
                if (this.visited.add(decl)) {
                    return this.ret(decl, this.iterator(decl.getModelGroup()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> modelGroup(XSModelGroup group2) {
                if (this.visited.add(group2)) {
                    return this.ret(group2, new Recursion(group2.iterator()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> attGroupDecl(XSAttGroupDecl decl) {
                if (this.visited.add(decl)) {
                    return this.ret(decl, new Recursion(decl.iterateAttributeUses()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> attributeUse(XSAttributeUse use) {
                if (this.visited.add(use)) {
                    return this.ret(use, this.iterator(use.getDecl()));
                }
                return this.empty();
            }

            @Override
            public Iterator<XSComponent> attributeDecl(XSAttributeDecl decl) {
                if (this.visited.add(decl)) {
                    return this.ret(decl, this.iterator(decl.getType()));
                }
                return this.empty();
            }

            private Iterator<XSComponent> ret(XSComponent one, Iterator<? extends XSComponent> rest) {
                return this.union(this.singleton(one), rest);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class Recursion
            extends Iterators.Map<XSComponent, XSComponent> {
                public Recursion(Iterator<? extends XSComponent> core) {
                    super(core);
                }

                @Override
                protected Iterator<XSComponent> apply(XSComponent u) {
                    return DESCENDANTS.iterator(u);
                }
            }
        }
    };
    public static final Axis<XSSchema> X_SCHEMA = new Axis<XSSchema>(){

        @Override
        public Iterator<XSSchema> iterator(XSComponent contextNode) {
            return Iterators.singleton(contextNode.getOwnerSchema());
        }

        @Override
        public Iterator<XSSchema> iterator(Iterator<? extends XSComponent> contextNodes) {
            return new Iterators.Adapter<XSSchema, XSComponent>(contextNodes){

                @Override
                protected XSSchema filter(XSComponent u) {
                    return u.getOwnerSchema();
                }
            };
        }

        @Override
        public boolean isModelGroup() {
            return false;
        }

        public String toString() {
            return "x-schema::";
        }
    };
    public static final Axis<XSElementDecl> SUBSTITUTION_GROUP = new AbstractAxisImpl<XSElementDecl>(){

        @Override
        public Iterator<XSElementDecl> elementDecl(XSElementDecl decl) {
            return this.singleton(decl.getSubstAffiliation());
        }

        public String toString() {
            return "substitutionGroup::";
        }
    };
    public static final Axis<XSAttributeDecl> ATTRIBUTE = new AbstractAxisImpl<XSAttributeDecl>(){

        @Override
        public Iterator<XSAttributeDecl> complexType(XSComplexType type) {
            return this.attributeHolder(type);
        }

        @Override
        public Iterator<XSAttributeDecl> attGroupDecl(XSAttGroupDecl decl) {
            return this.attributeHolder(decl);
        }

        private Iterator<XSAttributeDecl> attributeHolder(XSAttContainer atts) {
            return new Iterators.Adapter<XSAttributeDecl, XSAttributeUse>(atts.iterateAttributeUses()){

                @Override
                protected XSAttributeDecl filter(XSAttributeUse u) {
                    return u.getDecl();
                }
            };
        }

        @Override
        public Iterator<XSAttributeDecl> schema(XSSchema schema) {
            return schema.iterateAttributeDecls();
        }

        public String toString() {
            return "@";
        }
    };
    public static final Axis<XSElementDecl> ELEMENT = new AbstractAxisImpl<XSElementDecl>(){

        @Override
        public Iterator<XSElementDecl> particle(XSParticle particle2) {
            return this.singleton(particle2.getTerm().asElementDecl());
        }

        @Override
        public Iterator<XSElementDecl> schema(XSSchema schema) {
            return schema.iterateElementDecls();
        }

        @Override
        public Iterator<XSElementDecl> modelGroupDecl(XSModelGroupDecl decl) {
            return this.modelGroup(decl.getModelGroup());
        }

        @Override
        public String getName() {
            return "";
        }

        public String toString() {
            return "element::";
        }
    };
    public static final Axis<XSType> TYPE_DEFINITION = new AbstractAxisImpl<XSType>(){

        @Override
        public Iterator<XSType> schema(XSSchema schema) {
            return schema.iterateTypes();
        }

        @Override
        public Iterator<XSType> attributeDecl(XSAttributeDecl decl) {
            return this.singleton(decl.getType());
        }

        @Override
        public Iterator<XSType> elementDecl(XSElementDecl decl) {
            return this.singleton(decl.getType());
        }

        public String toString() {
            return "~";
        }
    };
    public static final Axis<XSType> BASETYPE = new AbstractAxisImpl<XSType>(){

        @Override
        public Iterator<XSType> simpleType(XSSimpleType type) {
            return this.singleton(type.getBaseType());
        }

        @Override
        public Iterator<XSType> complexType(XSComplexType type) {
            return this.singleton(type.getBaseType());
        }

        public String toString() {
            return "baseType::";
        }
    };
    public static final Axis<XSSimpleType> PRIMITIVE_TYPE = new AbstractAxisImpl<XSSimpleType>(){

        @Override
        public Iterator<XSSimpleType> simpleType(XSSimpleType type) {
            return this.singleton(type.getPrimitiveType());
        }

        public String toString() {
            return "primitiveType::";
        }
    };
    public static final Axis<XSSimpleType> ITEM_TYPE = new AbstractAxisImpl<XSSimpleType>(){

        @Override
        public Iterator<XSSimpleType> simpleType(XSSimpleType type) {
            XSListSimpleType baseList = type.getBaseListType();
            if (baseList == null) {
                return this.empty();
            }
            return this.singleton(baseList.getItemType());
        }

        public String toString() {
            return "itemType::";
        }
    };
    public static final Axis<XSSimpleType> MEMBER_TYPE = new AbstractAxisImpl<XSSimpleType>(){

        @Override
        public Iterator<XSSimpleType> simpleType(XSSimpleType type) {
            XSUnionSimpleType baseUnion = type.getBaseUnionType();
            if (baseUnion == null) {
                return this.empty();
            }
            return baseUnion.iterator();
        }

        public String toString() {
            return "memberType::";
        }
    };
    public static final Axis<XSComponent> SCOPE = new AbstractAxisImpl<XSComponent>(){

        @Override
        public Iterator<XSComponent> complexType(XSComplexType type) {
            return this.singleton(type.getScope());
        }

        public String toString() {
            return "scope::";
        }
    };
    public static final Axis<XSAttGroupDecl> ATTRIBUTE_GROUP = new AbstractAxisImpl<XSAttGroupDecl>(){

        @Override
        public Iterator<XSAttGroupDecl> schema(XSSchema schema) {
            return schema.iterateAttGroupDecls();
        }

        public String toString() {
            return "attributeGroup::";
        }
    };
    public static final Axis<XSModelGroupDecl> MODEL_GROUP_DECL = new AbstractAxisImpl<XSModelGroupDecl>(){

        @Override
        public Iterator<XSModelGroupDecl> schema(XSSchema schema) {
            return schema.iterateModelGroupDecls();
        }

        @Override
        public Iterator<XSModelGroupDecl> particle(XSParticle particle2) {
            return this.singleton(particle2.getTerm().asModelGroupDecl());
        }

        public String toString() {
            return "group::";
        }
    };
    public static final Axis<XSIdentityConstraint> IDENTITY_CONSTRAINT = new AbstractAxisImpl<XSIdentityConstraint>(){

        @Override
        public Iterator<XSIdentityConstraint> elementDecl(XSElementDecl decl) {
            return decl.getIdentityConstraints().iterator();
        }

        @Override
        public Iterator<XSIdentityConstraint> schema(XSSchema schema) {
            return super.schema(schema);
        }

        public String toString() {
            return "identityConstraint::";
        }
    };
    public static final Axis<XSIdentityConstraint> REFERENCED_KEY = new AbstractAxisImpl<XSIdentityConstraint>(){

        @Override
        public Iterator<XSIdentityConstraint> identityConstraint(XSIdentityConstraint decl) {
            return this.singleton(decl.getReferencedKey());
        }

        public String toString() {
            return "key::";
        }
    };
    public static final Axis<XSNotation> NOTATION = new AbstractAxisImpl<XSNotation>(){

        @Override
        public Iterator<XSNotation> schema(XSSchema schema) {
            return schema.iterateNotations();
        }

        public String toString() {
            return "notation::";
        }
    };
    public static final Axis<XSWildcard> WILDCARD = new AbstractAxisImpl<XSWildcard>(){

        @Override
        public Iterator<XSWildcard> particle(XSParticle particle2) {
            return this.singleton(particle2.getTerm().asWildcard());
        }

        public String toString() {
            return "any::";
        }
    };
    public static final Axis<XSWildcard> ATTRIBUTE_WILDCARD = new AbstractAxisImpl<XSWildcard>(){

        @Override
        public Iterator<XSWildcard> complexType(XSComplexType type) {
            return this.singleton(type.getAttributeWildcard());
        }

        @Override
        public Iterator<XSWildcard> attGroupDecl(XSAttGroupDecl decl) {
            return this.singleton(decl.getAttributeWildcard());
        }

        public String toString() {
            return "anyAttribute::";
        }
    };
    public static final Axis<XSFacet> FACET = new AbstractAxisImpl<XSFacet>(){

        @Override
        public Iterator<XSFacet> simpleType(XSSimpleType type) {
            XSRestrictionSimpleType r = type.asRestriction();
            if (r != null) {
                return r.iterateDeclaredFacets();
            }
            return this.empty();
        }

        public String toString() {
            return "facet::";
        }
    };
    public static final Axis<XSModelGroup> MODELGROUP_ALL = new ModelGroupAxis(XSModelGroup.Compositor.ALL);
    public static final Axis<XSModelGroup> MODELGROUP_CHOICE = new ModelGroupAxis(XSModelGroup.Compositor.CHOICE);
    public static final Axis<XSModelGroup> MODELGROUP_SEQUENCE = new ModelGroupAxis(XSModelGroup.Compositor.SEQUENCE);
    public static final Axis<XSModelGroup> MODELGROUP_ANY = new ModelGroupAxis(null);

    public Iterator<T> iterator(XSComponent var1);

    public Iterator<T> iterator(Iterator<? extends XSComponent> var1);

    public boolean isModelGroup();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModelGroupAxis
    extends AbstractAxisImpl<XSModelGroup> {
        private final XSModelGroup.Compositor compositor;

        ModelGroupAxis(XSModelGroup.Compositor compositor) {
            this.compositor = compositor;
        }

        @Override
        public boolean isModelGroup() {
            return true;
        }

        @Override
        public Iterator<XSModelGroup> particle(XSParticle particle2) {
            return this.filter(particle2.getTerm().asModelGroup());
        }

        @Override
        public Iterator<XSModelGroup> modelGroupDecl(XSModelGroupDecl decl) {
            return this.filter(decl.getModelGroup());
        }

        private Iterator<XSModelGroup> filter(XSModelGroup mg) {
            if (mg == null) {
                return this.empty();
            }
            if (mg.getCompositor() == this.compositor || this.compositor == null) {
                return this.singleton(mg);
            }
            return this.empty();
        }

        public String toString() {
            if (this.compositor == null) {
                return "model::*";
            }
            return "model::" + (Object)((Object)this.compositor);
        }
    }
}

