/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;

public abstract class ApBasedTask
extends Javac {
    protected ApBasedTask() {
    }

    protected abstract void setupCommandlineSwitches(Commandline var1);

    protected abstract Processor getProcessor();

    protected void compile() {
        InternalApAdapter ap;
        if (this.compileList.length == 0) {
            return;
        }
        this.log(this.getCompilationMessage() + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s"));
        if (this.listFiles) {
            for (File aCompileList : this.compileList) {
                String filename = aCompileList.getAbsolutePath();
                this.log(filename);
            }
        }
        if (!(ap = new InternalApAdapter()).execute()) {
            if (this.failOnError) {
                throw new BuildException(this.getFailedMessage(), this.getLocation());
            }
            this.log(this.getFailedMessage(), 0);
        }
    }

    protected abstract String getCompilationMessage();

    protected abstract String getFailedMessage();

    private final class InternalApAdapter
    extends ApAdapter {
        private InternalApAdapter() {
        }

        public boolean execute() throws BuildException {
            try {
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(this.compileList));
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, Arrays.asList(this.setupModernJavacCommand().getArguments()), null, compilationUnits);
                task.setProcessors(Collections.singleton(ApBasedTask.this.getProcessor()));
                return task.call();
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new BuildException("Error starting ap", (Throwable)ex, this.location);
            }
        }
    }

    private abstract class ApAdapter
    extends DefaultCompilerAdapter {
        protected ApAdapter() {
            this.setJavac(ApBasedTask.this);
        }

        protected Commandline setupModernJavacCommandlineSwitches(Commandline cmd) {
            super.setupModernJavacCommandlineSwitches(cmd);
            ApBasedTask.this.setupCommandlineSwitches(cmd);
            return cmd;
        }

        protected void logAndAddFilesToCompile(Commandline cmd) {
            this.attributes.log("Compilation " + cmd.describeArguments(), 3);
            StringBuilder niceSourceList = new StringBuilder("File");
            if (this.compileList.length != 1) {
                niceSourceList.append("s");
            }
            niceSourceList.append(" to be compiled:");
            niceSourceList.append(System.lineSeparator());
            StringBuilder tempbuilder = new StringBuilder();
            for (File aCompileList : this.compileList) {
                String arg = aCompileList.getAbsolutePath();
                tempbuilder.append("    ").append(arg).append(System.lineSeparator());
                niceSourceList.append((CharSequence)tempbuilder);
                tempbuilder.setLength(0);
            }
            this.attributes.log(niceSourceList.toString(), 3);
        }
    }
}

