/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import com.sun.jersey.samples.atomserver.resources.FeedResource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

@Path(value="/service")
@Produces(value={"application/atomserv+xml"})
public class ServiceResource {
    @Context
    UriInfo uriInfo;

    @GET
    public byte[] getService() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("service.xml");
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build(in);
            Element root = d.getRootElement();
            Namespace ns = root.getNamespace();
            Element collection = root.getChild("workspace", ns).getChild("collection", ns);
            collection.setAttribute("href", this.getCollectionUri());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLOutputter xmlo = new XMLOutputter();
            xmlo.output(d, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getCollectionUri() {
        return this.uriInfo.getBaseUriBuilder().path(FeedResource.class).build().toString();
    }
}

