/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import com.sun.jersey.samples.atomserver.resources.AtomStore;
import com.sun.jersey.samples.atomserver.resources.EditEntryResource;
import com.sun.jersey.samples.atomserver.resources.EntryResource;
import com.sun.jersey.samples.atomserver.resources.FileStore;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/collection")
@Produces(value={"application/atom+xml"})
public class FeedResource {
    @Context
    UriInfo uriInfo;
    @Context
    MessageBodyWorkers bodyContext;

    @Path(value="{entry}")
    public EntryResource getEntryResource(@PathParam(value="entry") String entryId) {
        return new EntryResource(entryId);
    }

    @Path(value="edit/{entry}")
    public EntryResource getEditEntryResource(@PathParam(value="entry") String entryId) {
        return new EditEntryResource(entryId, this.uriInfo, this.bodyContext);
    }

    private UriBuilder getEditUriBuilder() {
        return this.uriInfo.getAbsolutePathBuilder().path(new String[]{"edit"});
    }

    @GET
    public Feed getFeed() throws IOException, FeedException {
        return AtomStore.getFeedDocument(this.bodyContext, this.uriInfo.getAbsolutePath());
    }

    @POST
    @Consumes(value={"application/atom+xml"})
    public Response postEntry(Entry e) throws IOException, FeedException {
        String entryId = FileStore.FS.getNextId();
        URI entryUri = this.uriInfo.getAbsolutePathBuilder().path(new String[]{entryId}).build();
        AtomStore.addLink(e, "self", entryUri);
        URI editEntryUri = this.getEditUriBuilder().path(new String[]{entryId}).build();
        AtomStore.addLink(e, "edit", editEntryUri);
        e.setId(entryId);
        AtomStore.createEntryDocument(this.bodyContext, entryId, e);
        Feed f = AtomStore.getFeedDocument(this.bodyContext, this.uriInfo.getAbsolutePath());
        AtomStore.updateFeedDocumentWithNewEntry(this.bodyContext, f, e);
        return Response.created((URI)entryUri).entity((Object)e).build();
    }

    @POST
    public Response postMediaEntry(@Context HttpHeaders headers, byte[] entry) throws IOException, FeedException {
        String entryId = FileStore.FS.getNextId();
        Entry e = AtomStore.createDefaulMediaLinkEntryDocument();
        UriBuilder entryUriBuilder = this.uriInfo.getAbsolutePathBuilder().path(new String[]{entryId});
        UriBuilder editEntryUriBuilder = this.getEditUriBuilder().path(new String[]{entryId});
        URI entryUri = entryUriBuilder.build();
        AtomStore.addLink(e, "self", entryUri);
        URI editEntryUri = editEntryUriBuilder.build();
        AtomStore.addLink(e, "edit", editEntryUri);
        URI editMediaUri = editEntryUriBuilder.path(new String[]{"media"}).build();
        AtomStore.addLink(e, "edit-media", editMediaUri);
        e.setId(entryId);
        Content c = new Content();
        c.setType(headers.getMediaType().toString());
        URI mediaUri = entryUriBuilder.path(new String[]{"media"}).build();
        c.setSrc(mediaUri.toString());
        e.getContents().add(c);
        AtomStore.createEntryDocument(this.bodyContext, entryId, e);
        AtomStore.createMediaDocument(entryId, entry);
        Feed f = AtomStore.getFeedDocument(this.bodyContext, this.uriInfo.getAbsolutePath());
        AtomStore.updateFeedDocumentWithNewEntry(this.bodyContext, f, e);
        return Response.created((URI)entryUri).entity((Object)e).build();
    }
}

