/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import com.sun.jersey.samples.atomserver.resources.AtomStore;
import com.sun.jersey.samples.atomserver.resources.EntryResource;
import com.sun.jersey.samples.atomserver.resources.FeedResource;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class EditEntryResource
extends EntryResource {
    protected UriInfo uriInfo;
    protected MessageBodyWorkers bodyContext;

    public EditEntryResource(String entryId, UriInfo uriInfo, MessageBodyWorkers bodyContext) {
        super(entryId);
        this.uriInfo = uriInfo;
        this.bodyContext = bodyContext;
    }

    @PUT
    public Entry putEntry(Entry e) throws IOException, FeedException {
        UriBuilder entryUri = this.uriInfo.getBaseUriBuilder().path(FeedResource.class).path(new String[]{this.entryId});
        AtomStore.updateLink(e, "self", entryUri.build());
        UriBuilder editEntryUri = this.getUriBuilder();
        AtomStore.updateLink(e, "edit", editEntryUri.build());
        if (AtomStore.hasMedia(this.entryId)) {
            URI mediaUri = entryUri.path(new String[]{"media"}).build();
            URI editMediaUri = editEntryUri.path(new String[]{"media"}).build();
            AtomStore.updateLink(e, "edit-media", editMediaUri);
        }
        e.setId(this.entryId);
        e.setForeignMarkup(null);
        AtomStore.createEntryDocument(this.bodyContext, this.entryId, e);
        Feed f = AtomStore.getFeedDocument();
        AtomStore.updateFeedDocumentWithExistingEntry(this.bodyContext, f, e);
        return e;
    }

    @DELETE
    public void deleteEntry() throws IOException, FeedException {
        AtomStore.deleteEntry(this.entryId);
        Feed f = AtomStore.getFeedDocument();
        AtomStore.updateFeedDocumentRemovingEntry(this.bodyContext, f, this.entryId);
    }

    @PUT
    @Path(value="media")
    @Consumes(value={"*/*"})
    public void putMedia(@Context HttpHeaders headers, byte[] update) throws IOException, FeedException {
        String mediaPath = AtomStore.getMediaPath(this.entryId);
        AtomStore.checkExistence(mediaPath);
        Feed f = AtomStore.getFeedDocument();
        Entry e = AtomStore.findEntry(this.entryId, f);
        e.setUpdated(new Date());
        UriBuilder editMediaEntryUri = this.getUriBuilder();
        AtomStore.updateLink(e, "edit-media", editMediaEntryUri.build());
        editMediaEntryUri.path(new String[]{".."});
        AtomStore.updateLink(e, "edit", editMediaEntryUri.build().normalize());
        AtomStore.updateFeedDocument(this.bodyContext, f);
        AtomStore.createEntryDocument(this.bodyContext, this.entryId, e);
        AtomStore.createMediaDocument(this.entryId, update);
    }

    protected UriBuilder getUriBuilder() {
        return this.uriInfo.getAbsolutePathBuilder();
    }
}

