/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.jacksonjsonprovider;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.samples.jacksonjsonprovider.MyApplication;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;

public class Main {
    public static final URI BASE_URI = Main.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/jacksonjsonprovider/").port(Main.getPort(9998)).build(new Object[0]);
    }

    public static HttpServer startServer() throws IOException {
        ApplicationAdapter rc = new ApplicationAdapter((Application)new MyApplication());
        rc.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        return GrizzlyServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)rc);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Starting grizzly...");
        HttpServer httpServer = Main.startServer();
        System.out.println(String.format("Jersey app started with WADL available at %sapplication.wadl\nHit enter to stop it...", BASE_URI));
        System.in.read();
        httpServer.stop();
    }
}

