/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.https_grizzly;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.samples.https_grizzly.auth.SecurityFilter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;

public class Server {
    private static GrizzlyWebServer webServer;
    public static final URI BASE_URI;
    public static final String CONTENT = "JERSEY HTTPS EXAMPLE\n";

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"https://localhost/").port(Server.getPort(4463)).build(new Object[0]);
    }

    private static int getPort(int defaultPort) {
        String port = System.getenv("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    protected static void startServer() {
        webServer = new GrizzlyWebServer(Server.getPort(4463), ".", true);
        ServletAdapter jerseyAdapter = new ServletAdapter();
        jerseyAdapter.addInitParameter("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.https_grizzly.resource;com.sun.jersey.samples.https_grizzly.auth");
        jerseyAdapter.setContextPath("/");
        jerseyAdapter.setServletInstance((Servlet)new ServletContainer());
        jerseyAdapter.addInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", SecurityFilter.class.getName());
        webServer.addGrizzlyAdapter((GrizzlyAdapter)jerseyAdapter, new String[]{"/"});
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setKeyStoreFile("./keystore_server");
        sslConfig.setKeyStorePass("asdfgh");
        sslConfig.setTrustStoreFile("./truststore_server");
        sslConfig.setTrustStorePass("asdfgh");
        webServer.setSSLConfig(sslConfig);
        ((SSLSelectorThread)webServer.getSelectorThread()).setNeedClientAuth(true);
        try {
            System.out.println("Jersey app started. Try out " + BASE_URI + "\nHit CTRL + C to stop it...");
            webServer.start();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void stopServer() {
        webServer.stop();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Server.startServer();
    }

    static {
        BASE_URI = Server.getBaseURI();
    }
}

