/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.https_grizzly.auth;

import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.samples.https_grizzly.auth.AuthenticationException;
import com.sun.jersey.samples.https_grizzly.auth.Base64;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.security.Principal;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

public class SecurityFilter
implements ContainerRequestFilter {
    @Context
    UriInfo uriInfo;
    private static final String REALM = "HTTPS Example authentization";

    public ContainerRequest filter(ContainerRequest request) {
        User user = this.authenticate(request);
        request.setSecurityContext((SecurityContext)new Authorizer(user));
        return request;
    }

    private User authenticate(ContainerRequest request) {
        String authentication = request.getHeaderValue("Authorization");
        if (authentication == null) {
            throw new MappableContainerException((Throwable)new AuthenticationException("Authentication credentials are required", REALM));
        }
        if (!authentication.startsWith("Basic ")) {
            return null;
        }
        String[] values = new String(Base64.base64Decode(authentication = authentication.substring("Basic ".length()))).split(":");
        if (values.length < 2) {
            return null;
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            return null;
        }
        User user = null;
        if (!username.equals("user") || !password.trim().equals("password")) {
            System.out.println("USER NOT AUTHENTICATED");
            throw new MappableContainerException((Throwable)new AuthenticationException("Invalid username or password\r\n", REALM));
        }
        user = new User("user", "user");
        System.out.println("USER AUTHENTICATED");
        return user;
    }

    public class User {
        public String username;
        public String role;

        public User(String username, String role) {
            this.username = username;
            this.role = role;
        }
    }

    public class Authorizer
    implements SecurityContext {
        private User user;
        private Principal principal;

        public Authorizer(final User user) {
            this.user = user;
            this.principal = new Principal(){

                public String getName() {
                    return user.username;
                }
            };
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return role.equals(this.user.role);
        }

        public boolean isSecure() {
            return "https".equals(SecurityFilter.this.uriInfo.getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

