/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.helloworld;

import com.sun.grizzly.http.SelectorThread;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;

public class Main {
    public static final URI BASE_URI = Main.getBaseURI();

    private static int getPort(int defaultPort) {
        String port = System.getenv("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(Main.getPort(9998)).build(new Object[0]);
    }

    protected static SelectorThread startServer() throws IOException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.config.property.packages", "com.sun.jersey.samples.helloworld.resources");
        System.out.println("Starting grizzly...");
        SelectorThread threadSelector = GrizzlyWebContainerFactory.create((URI)BASE_URI, initParams);
        return threadSelector;
    }

    public static void main(String[] args) throws IOException {
        SelectorThread threadSelector = Main.startServer();
        System.out.println(String.format("Jersey app started with WADL available at %sapplication.wadl\nTry out %shelloworld\nHit enter to stop it...", BASE_URI, BASE_URI));
        System.in.read();
        threadSelector.stopEndpoint();
    }
}

