/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.impl.container.inmemory;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResourceClientHandler
extends TerminatingClientHandler {
    private final WebApplication w;
    private final URI baseUri;

    public TestResourceClientHandler(URI baseUri, WebApplication w) {
        this.baseUri = baseUri;
        this.w = w;
    }

    public ClientResponse handle(ClientRequest clientRequest) {
        byte[] requestEntity = this.writeRequestEntity(clientRequest);
        InBoundHeaders rh = this.getInBoundHeaders((MultivaluedMap<String, Object>)clientRequest.getMetadata());
        ContainerRequest cRequest = new ContainerRequest(this.w, clientRequest.getMethod(), this.baseUri, clientRequest.getURI(), rh, (InputStream)new ByteArrayInputStream(requestEntity));
        List cookies = (List)cRequest.getRequestHeaders().get((Object)"Cookie");
        if (cookies != null) {
            for (String cookie : cookies) {
                if (cookie == null) continue;
                cRequest.getCookies().putAll(HttpHeaderReader.readCookies((String)cookie));
            }
        }
        TestContainerResponseWriter writer = new TestContainerResponseWriter();
        ContainerResponse cResponse = new ContainerResponse(this.w, cRequest, (ContainerResponseWriter)writer);
        try {
            this.w.handleRequest(cRequest, cResponse);
        }
        catch (IOException e) {
            throw new ContainerException((Throwable)e);
        }
        byte[] responseEntity = writer.baos.toByteArray();
        ClientResponse clientResponse = new ClientResponse(cResponse.getStatus(), this.getInBoundHeaders((MultivaluedMap<String, Object>)cResponse.getHttpHeaders()), (InputStream)new ByteArrayInputStream(responseEntity), this.getMessageBodyWorkers());
        clientResponse.getProperties().put("request.entity", requestEntity);
        clientResponse.getProperties().put("response.entity", responseEntity);
        return clientResponse;
    }

    private InBoundHeaders getInBoundHeaders(MultivaluedMap<String, Object> outBound) {
        InBoundHeaders inBound = new InBoundHeaders();
        for (Map.Entry e : outBound.entrySet()) {
            for (Object v : (List)e.getValue()) {
                inBound.add((String)e.getKey(), (Object)this.headerValueToString(v));
            }
        }
        return inBound;
    }

    private byte[] writeRequestEntity(ClientRequest ro) {
        try {
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeRequestEntity(ro, new TerminatingClientHandler.RequestEntityWriterListener(){

                public void onRequestEntitySize(long size) throws IOException {
                }

                public OutputStream onGetOutputStream() throws IOException {
                    return baos;
                }
            });
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new ClientHandlerException((Throwable)ex);
        }
    }

    private static class TestContainerResponseWriter
    implements ContainerResponseWriter {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private TestContainerResponseWriter() {
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            return this.baos;
        }

        public void finish() throws IOException {
        }
    }
}

