/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.embedded.glassfish;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.impl.container.embedded.glassfish.WebXmlGenerator;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.embed.EmbeddedException;
import org.glassfish.embed.EmbeddedInfo;
import org.glassfish.embed.ScatteredArchive;
import org.glassfish.embed.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedGlassFishTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    @Override
    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new EmbeddedGlassFishTestContainer(baseUri, (WebAppDescriptor)ad);
    }

    private static class EmbeddedGlassFishTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(EmbeddedGlassFishTestContainer.class.getName());
        private ScatteredArchive war;
        private Server server;
        private EmbeddedInfo embeddedInfo;
        private WebAppDescriptor appDescriptor;
        final URI baseUri;
        final String WEB_XML = "web.xml";
        final String WEB_INF_PATH = "WEB-INF";
        final String TARGET_WEBAPP_PATH = "target/webapp";
        final String SRC_WEBAPP_PATH = "src/main/webapp";
        final String TARGET_CLASSES_PATH = "target/classes";

        private EmbeddedGlassFishTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
            this.appDescriptor = ad;
            LOGGER.info("Creating EmbeddedGlassFish test container configured at the base URI " + this.baseUri);
            this.instantiateServer();
            this.createArchive();
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.info("Starting the EmbeddedGlassFish instance...");
            try {
                this.server.start();
                this.server.getDeployer().deploy((ReadableArchive)this.war, null);
            }
            catch (EmbeddedException ex) {
                throw new TestContainerException(ex);
            }
        }

        public void stop() {
            LOGGER.info("Stopping the EmbeddedGlassFish instance...");
            try {
                this.server.getDeployer().undeployAll();
                this.server.stop();
            }
            catch (EmbeddedException ex) {
                throw new TestContainerException(ex);
            }
        }

        private void instantiateServer() {
            this.embeddedInfo = new EmbeddedInfo();
            this.embeddedInfo.setLogging(false);
            this.embeddedInfo.setHttpPort(this.baseUri.getPort());
            this.embeddedInfo.setServerName("EmbeddedGFServer");
            this.server = Server.getServer((String)"EmbeddedGFServer");
            if (this.server == null) {
                try {
                    this.server = new Server(this.embeddedInfo);
                }
                catch (EmbeddedException ex) {
                    throw new TestContainerException(ex);
                }
            }
        }

        private boolean webXmlGeneratedOnTheFly() {
            if (!this.webXmlExists()) {
                File webXmlDir = new File("target/webapp/WEB-INF");
                webXmlDir.mkdirs();
                File webXml = new File("target/webapp/WEB-INF/web.xml");
                try {
                    FileOutputStream outputStream = new FileOutputStream(webXml);
                    WebXmlGenerator webXmlGenerator = new WebXmlGenerator(this.appDescriptor);
                    try {
                        webXmlGenerator.marshalData(outputStream);
                    }
                    catch (JAXBException ex) {
                        throw new TestContainerException(ex);
                    }
                    ((OutputStream)outputStream).close();
                }
                catch (FileNotFoundException ex) {
                    throw new TestContainerException(ex);
                }
                catch (IOException ex) {
                    throw new TestContainerException(ex);
                }
                return true;
            }
            return false;
        }

        private boolean webXmlExists() {
            File webXml = new File("src/main/webapp/WEB-INF/web.xml");
            return webXml.exists();
        }

        private void createArchive() {
            if (!this.webXmlGeneratedOnTheFly()) {
                try {
                    this.war = new ScatteredArchive(this.baseUri.getRawPath(), new File("src/main/webapp"), new File("src/main/webapp/WEB-INF/web.xml"), Collections.singleton(new File("target/classes").toURI().toURL()));
                }
                catch (MalformedURLException ex) {
                    throw new TestContainerException(ex);
                }
            }
            try {
                this.war = new ScatteredArchive(this.baseUri.getRawPath(), new File("target/webapp"), new File("target/webapp/WEB-INF/web.xml"), Collections.singleton(new File("target/classes").toURI().toURL()));
            }
            catch (MalformedURLException ex) {
                throw new TestContainerException(ex);
            }
        }
    }
}

