/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import com.sun.jersey.server.linking.Link;
import com.sun.jersey.server.linking.Links;
import com.sun.jersey.server.linking.Ref;
import com.sun.jersey.server.linking.impl.FieldDescriptor;
import com.sun.jersey.server.linking.impl.LinkDescriptor;
import com.sun.jersey.server.linking.impl.RefFieldDescriptor;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityDescriptor {
    private static Map<Class<?>, EntityDescriptor> descriptors = new HashMap();
    private Map<String, FieldDescriptor> nonLinkFields;
    private Map<String, RefFieldDescriptor> linkFields;
    private List<LinkDescriptor> linkHeaders = new ArrayList<LinkDescriptor>();

    public static synchronized EntityDescriptor getInstance(Class<?> entityClass) {
        if (descriptors.containsKey(entityClass)) {
            return descriptors.get(entityClass);
        }
        EntityDescriptor descriptor = new EntityDescriptor(entityClass);
        descriptors.put(entityClass, descriptor);
        return descriptor;
    }

    private EntityDescriptor(Class<?> entityClass) {
        this.findLinkHeaders(entityClass);
        this.linkHeaders = Collections.unmodifiableList(this.linkHeaders);
        this.nonLinkFields = new HashMap<String, FieldDescriptor>();
        this.linkFields = new HashMap<String, RefFieldDescriptor>();
        this.findFields(entityClass);
        this.nonLinkFields = Collections.unmodifiableMap(this.nonLinkFields);
        this.linkFields = Collections.unmodifiableMap(this.linkFields);
    }

    public Collection<RefFieldDescriptor> getLinkFields() {
        return this.linkFields.values();
    }

    public Collection<FieldDescriptor> getNonLinkFields() {
        return this.nonLinkFields.values();
    }

    public List<LinkDescriptor> getLinkHeaders() {
        return this.linkHeaders;
    }

    private void findFields(Class<?> entityClass) {
        for (Field f : entityClass.getDeclaredFields()) {
            Ref a = f.getAnnotation(Ref.class);
            if (a != null) {
                Class<?> t = f.getType();
                if (!t.equals(String.class) && !t.equals(URI.class) || this.linkFields.containsKey(f.getName())) continue;
                this.linkFields.put(f.getName(), new RefFieldDescriptor(f, a, t));
                continue;
            }
            this.nonLinkFields.put(f.getName(), new FieldDescriptor(f));
        }
        Class<?> sc = entityClass.getSuperclass();
        if (sc != null && sc != Object.class) {
            this.findFields(sc);
        }
        for (Class<?> ic : entityClass.getInterfaces()) {
            this.findFields(ic);
        }
    }

    private void findLinkHeaders(Class<?> entityClass) {
        Class<?> sc;
        Links linkHeadersAnnotation;
        Link linkHeaderAnnotation = entityClass.getAnnotation(Link.class);
        if (linkHeaderAnnotation != null) {
            this.linkHeaders.add(new LinkDescriptor(linkHeaderAnnotation));
        }
        if ((linkHeadersAnnotation = entityClass.getAnnotation(Links.class)) != null) {
            for (Link linkHeader : linkHeadersAnnotation.value()) {
                this.linkHeaders.add(new LinkDescriptor(linkHeader));
            }
        }
        if ((sc = entityClass.getSuperclass()) != null && sc != Object.class) {
            this.findLinkHeaders(sc);
        }
        for (Class<?> ic : entityClass.getInterfaces()) {
            this.findLinkHeaders(ic);
        }
    }
}

