/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import com.sun.jersey.server.linking.Binding;
import com.sun.jersey.server.linking.Link;
import com.sun.jersey.server.linking.Ref;
import com.sun.jersey.server.linking.impl.RefDescriptor;
import com.sun.jersey.server.linking.impl.RefFieldDescriptor;
import java.util.HashMap;
import java.util.Map;

public class LinkDescriptor
implements RefDescriptor {
    private Link linkHeader;
    private Map<String, String> bindings;

    LinkDescriptor(Link linkHeader) {
        this.linkHeader = linkHeader;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : linkHeader.value().bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    public Link getLinkHeader() {
        return this.linkHeader;
    }

    @Override
    public String getLinkTemplate() {
        return RefFieldDescriptor.getLinkTemplate(this.linkHeader.value());
    }

    @Override
    public Ref.Style getLinkStyle() {
        return this.linkHeader.value().style();
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.linkHeader.value().condition();
    }
}

