/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import com.sun.jersey.core.header.LinkHeader;
import com.sun.jersey.server.linking.Link;
import com.sun.jersey.server.linking.el.LinkBuilder;
import com.sun.jersey.server.linking.impl.EntityDescriptor;
import com.sun.jersey.server.linking.impl.LinkDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class LinkProcessor<T> {
    private EntityDescriptor instanceDescriptor;

    public LinkProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    public void processLinkHeaders(T entity, UriInfo uriInfo, MultivaluedMap<String, Object> headers) {
        List<String> headerValues = this.getLinkHeaderValues(entity, uriInfo);
        for (String headerValue : headerValues) {
            headers.add((Object)"Link", (Object)headerValue);
        }
    }

    List<String> getLinkHeaderValues(Object entity, UriInfo uriInfo) {
        List matchedResources = uriInfo.getMatchedResources();
        if (!matchedResources.isEmpty()) {
            Object resource = matchedResources.get(0);
            ArrayList<String> headerValues = new ArrayList<String>();
            for (LinkDescriptor desc : this.instanceDescriptor.getLinkHeaders()) {
                if (!LinkBuilder.evaluateCondition(desc.getCondition(), entity, resource, entity)) continue;
                String headerValue = LinkProcessor.getLinkHeaderValue(desc, entity, resource, uriInfo);
                headerValues.add(headerValue);
            }
            return headerValues;
        }
        return Collections.emptyList();
    }

    static String getLinkHeaderValue(LinkDescriptor desc, Object entity, Object resource, UriInfo uriInfo) {
        URI uri = LinkBuilder.buildURI(desc, entity, resource, entity, uriInfo);
        Link header = desc.getLinkHeader();
        LinkHeader.LinkHeaderBuilder builder = LinkHeader.uri((URI)uri);
        if (header.rel().length() != 0) {
            builder = builder.rel(header.rel());
        }
        if (header.rev().length() != 0) {
            builder = builder.parameter("rev", header.rev());
        }
        if (header.type().length() != 0) {
            builder = builder.type(MediaType.valueOf((String)header.type()));
        }
        if (header.title().length() != 0) {
            builder = builder.parameter("title", header.title());
        }
        if (header.anchor().length() != 0) {
            builder = builder.parameter("anchor", header.anchor());
        }
        if (header.media().length() != 0) {
            builder = builder.parameter("media", header.media());
        }
        if (header.hreflang().length() != 0) {
            builder = builder.parameter("hreflang", header.hreflang());
        }
        for (Link.Extension ext : header.extensions()) {
            builder = builder.parameter(ext.name(), ext.value());
        }
        return builder.build().toString();
    }
}

