/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldDescriptor {
    protected Field field;

    FieldDescriptor(Field f) {
        this.field = f;
    }

    public Object getFieldValue(Object instance) {
        FieldDescriptor.setAccessibleField(this.field);
        Object value = null;
        try {
            value = this.field.get(instance);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(FieldDescriptor.class.getName()).log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FieldDescriptor.class.getName()).log(Level.FINE, null, ex);
        }
        return value;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    protected static void setAccessibleField(final Field f) {
        if (Modifier.isPublic(f.getModifiers())) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                return f;
            }
        });
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldDescriptor other = (FieldDescriptor)obj;
        return this.field == other.field || this.field != null && this.field.equals(other.field);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.field != null ? this.field.hashCode() : 0);
        return hash;
    }
}

