/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.monitoring;

import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.monitoring.DispatchingListener;
import com.sun.jersey.spi.monitoring.DispatchingListenerAdapter;
import com.sun.jersey.spi.monitoring.RequestListener;
import com.sun.jersey.spi.monitoring.RequestListenerAdapter;
import com.sun.jersey.spi.monitoring.ResponseListener;
import com.sun.jersey.spi.monitoring.ResponseListenerAdapter;
import javax.ws.rs.ext.ExceptionMapper;

public final class MonitoringProviderFactory {
    private static final EmptyListener EMPTY_LISTENER = new EmptyListener();

    private MonitoringProviderFactory() {
    }

    public static RequestListener createRequestListener(ProviderServices providerServices) {
        RequestListener requestListener = EMPTY_LISTENER;
        for (RequestListenerAdapter a : providerServices.getProvidersAndServices(RequestListenerAdapter.class)) {
            requestListener = a.adapt(requestListener);
        }
        return requestListener;
    }

    public static DispatchingListener createDispatchingListener(ProviderServices providerServices) {
        DispatchingListener dispatchingListener = EMPTY_LISTENER;
        for (DispatchingListenerAdapter a : providerServices.getProvidersAndServices(DispatchingListenerAdapter.class)) {
            dispatchingListener = a.adapt(dispatchingListener);
        }
        return dispatchingListener;
    }

    public static ResponseListener createResponseListener(ProviderServices providerServices) {
        ResponseListener responseListener = EMPTY_LISTENER;
        for (ResponseListenerAdapter a : providerServices.getProvidersAndServices(ResponseListenerAdapter.class)) {
            responseListener = a.adapt(responseListener);
        }
        return responseListener;
    }

    private static class EmptyListener
    implements RequestListener,
    ResponseListener,
    DispatchingListener {
        private EmptyListener() {
        }

        @Override
        public void onSubResource(long id, Class subResource) {
        }

        @Override
        public void onSubResourceLocator(long id, AbstractSubResourceLocator locator) {
        }

        @Override
        public void onResourceMethod(long id, AbstractResourceMethod method) {
        }

        @Override
        public void onRequest(long id, ContainerRequest request) {
        }

        @Override
        public void onError(long id, Throwable ex) {
        }

        @Override
        public void onResponse(long id, ContainerResponse response) {
        }

        @Override
        public void onMappedException(long id, Throwable exception, ExceptionMapper mapper) {
        }
    }
}

