/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.factory;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.core.util.KeyComparatorHashMap;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextResolverFactory {
    private final Map<Type, Map<MediaType, ContextResolver>> resolver;

    public ContextResolverFactory(ProviderServices providersServices, InjectableProviderFactory ipf) {
        HashMap rs = new HashMap();
        Set<ContextResolver> providers = providersServices.getProviders(ContextResolver.class);
        for (ContextResolver contextResolver : providers) {
            List<MediaType> ms = MediaTypes.createMediaTypes(contextResolver.getClass().getAnnotation(Produces.class));
            ParameterizedType pType = this.getType(contextResolver.getClass());
            Type type = pType.getActualTypeArguments()[0];
            HashMap<MediaType, HashSet<ContextResolver>> mr = (HashMap<MediaType, HashSet<ContextResolver>>)rs.get(type);
            if (mr == null) {
                mr = new HashMap<MediaType, HashSet<ContextResolver>>();
                rs.put(type, mr);
            }
            for (MediaType m : ms) {
                HashSet<ContextResolver> sr = (HashSet<ContextResolver>)mr.get(m);
                if (sr == null) {
                    sr = new HashSet<ContextResolver>();
                    mr.put(m, sr);
                }
                sr.add(contextResolver);
            }
        }
        this.resolver = new HashMap<Type, Map<MediaType, ContextResolver>>(4);
        for (Map.Entry entry : rs.entrySet()) {
            KeyComparatorHashMap<MediaType, ContextResolver> mr = new KeyComparatorHashMap<MediaType, ContextResolver>(4, MessageBodyFactory.MEDIA_TYPE_COMPARATOR);
            this.resolver.put((Type)entry.getKey(), (Map<MediaType, ContextResolver>)mr);
            for (Map.Entry f : ((Map)entry.getValue()).entrySet()) {
                mr.put((MediaType)f.getKey(), this.reduce((Set)f.getValue()));
            }
        }
        ipf.add(new InjectableProvider<Context, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable getInjectable(ComponentContext ic, Context ac, Type c) {
                if (!(c instanceof ParameterizedType)) {
                    return null;
                }
                ParameterizedType pType = (ParameterizedType)c;
                if (pType.getRawType() != ContextResolver.class) {
                    return null;
                }
                Type type = pType.getActualTypeArguments()[0];
                final ContextResolver cr = this.getResolver(ic, type);
                if (cr == null) {
                    return null;
                }
                return new Injectable(){

                    public Object getValue() {
                        return cr;
                    }
                };
            }

            ContextResolver getResolver(ComponentContext ic, Type type) {
                ContextResolver cr = null;
                List<MediaType> ms = this.getMediaTypes(ic);
                if (ms.size() == 1) {
                    cr = ContextResolverFactory.this.resolve(type, ms.get(0));
                    if (cr == null) {
                        return null;
                    }
                } else {
                    HashSet<ContextResolver> scr = new HashSet<ContextResolver>();
                    for (MediaType m : ms) {
                        cr = ContextResolverFactory.this.resolve(type, m);
                        if (cr == null) continue;
                        scr.add(cr);
                    }
                    if (scr.isEmpty()) {
                        return null;
                    }
                    cr = new ContextResolver(scr);
                }
                return cr;
            }

            List<MediaType> getMediaTypes(ComponentContext ic) {
                Produces p = null;
                for (Annotation a : ic.getAnnotations()) {
                    if (!(a instanceof Produces)) continue;
                    p = (Produces)a;
                    break;
                }
                return MediaTypes.createMediaTypes(p);
            }
        });
    }

    private ParameterizedType getType(Class providerClass) {
        while (providerClass != null) {
            for (Type type : providerClass.getGenericInterfaces()) {
                ParameterizedType pType;
                if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ContextResolver.class) continue;
                return pType;
            }
            providerClass = providerClass.getSuperclass();
        }
        throw new IllegalArgumentException();
    }

    private ContextResolver reduce(Set<ContextResolver> r) {
        if (r.size() == 1) {
            return r.iterator().next();
        }
        return new ContextResolverAdapter(r);
    }

    public <T> ContextResolver<T> resolve(Type t, MediaType m) {
        Map<MediaType, ContextResolver> x = this.resolver.get(t);
        if (x == null) {
            return null;
        }
        if (m == null) {
            m = MediaTypes.GENERAL_MEDIA_TYPE;
        }
        return x.get(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextResolverAdapter
    implements ContextResolver {
        private final Set<ContextResolver> crs;

        ContextResolverAdapter(Set<ContextResolver> crs) {
            this.crs = crs;
        }

        public Object getContext(Class objectType) {
            for (ContextResolver cr : this.crs) {
                Object c = cr.getContext(objectType);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }
}

