/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.application;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessor;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCProviderFactory;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.ThreadLocalHttpContext;
import com.sun.jersey.server.impl.application.CloseableServiceFactory;
import com.sun.jersey.server.impl.application.ExceptionMapperFactory;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.application.WebApplicationContext;
import com.sun.jersey.server.impl.component.IoCResourceFactory;
import com.sun.jersey.server.impl.component.ResourceFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderFactory;
import com.sun.jersey.server.impl.model.ResourceClass;
import com.sun.jersey.server.impl.model.RulesMap;
import com.sun.jersey.server.impl.model.parameter.CookieParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HeaderParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HttpContextInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.MatrixParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.PathParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.QueryParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorFactory;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringReaderFactory;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.impl.modelapi.validation.BasicValidator;
import com.sun.jersey.server.impl.resource.PerRequestFactory;
import com.sun.jersey.server.impl.template.TemplateFactory;
import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.server.impl.uri.PathTemplate;
import com.sun.jersey.server.impl.uri.rules.ResourceClassRule;
import com.sun.jersey.server.impl.uri.rules.ResourceObjectRule;
import com.sun.jersey.server.impl.uri.rules.RightHandPathRule;
import com.sun.jersey.server.impl.uri.rules.RootResourceClassesRule;
import com.sun.jersey.server.impl.wadl.WadlFactory;
import com.sun.jersey.server.impl.wadl.WadlResource;
import com.sun.jersey.server.spi.component.ResourceComponentInjector;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.StringReaderWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.uri.rules.UriRule;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationImpl
implements WebApplication {
    private static final Logger LOGGER = Logger.getLogger(WebApplicationImpl.class.getName());
    private final Map<Class, AbstractResource> abstractResourceMap = new HashMap<Class, AbstractResource>();
    private final ConcurrentMap<Class, ResourceClass> metaClassMap = new ConcurrentHashMap<Class, ResourceClass>();
    private final ThreadLocalHttpContext context = new ThreadLocalHttpContext();
    private final CloseableServiceFactory closeableFactory;
    private boolean initiated;
    private ResourceConfig resourceConfig;
    private RootResourceClassesRule rootsRule;
    private ServerInjectableProviderFactory injectableFactory;
    private ProviderFactory cpFactory;
    private ResourceFactory rcpFactory;
    private IoCComponentProviderFactory provider;
    private List<IoCComponentProviderFactory> providerFactories;
    private MessageBodyFactory bodyFactory;
    private StringReaderFactory stringReaderFactory;
    private TemplateContext templateContext;
    private ExceptionMapperFactory exceptionFactory;
    private ResourceMethodDispatcherFactory dispatcherFactory;
    private ResourceContext resourceContext;
    private FilterFactory filterFactory;
    private WadlFactory wadlFactory;

    public WebApplicationImpl() {
        InvocationHandler requestHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)WebApplicationImpl.this.context.getRequest(), args);
            }
        };
        InvocationHandler uriInfoHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)WebApplicationImpl.this.context.getUriInfo(), args);
            }
        };
        this.injectableFactory = new ServerInjectableProviderFactory();
        this.injectableFactory.add(new ContextInjectableProvider<ServerInjectableProviderFactory>((Type)((Object)InjectableProviderContext.class), this.injectableFactory));
        this.injectableFactory.add(new ContextInjectableProvider<ServerInjectableProviderFactory>((Type)((Object)ServerInjectableProviderContext.class), this.injectableFactory));
        final HashMap<Class, Object> m = new HashMap<Class, Object>();
        m.put(HttpContext.class, this.context);
        m.put(HttpHeaders.class, this.createProxy(HttpHeaders.class, requestHandler));
        m.put(UriInfo.class, this.createProxy(UriInfo.class, uriInfoHandler));
        m.put(ExtendedUriInfo.class, this.createProxy(ExtendedUriInfo.class, uriInfoHandler));
        m.put(Request.class, this.createProxy(Request.class, requestHandler));
        m.put(SecurityContext.class, this.createProxy(SecurityContext.class, requestHandler));
        this.injectableFactory.add(new InjectableProvider<Context, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable getInjectable(ComponentContext ic, Context a, Type c) {
                final Object o = m.get(c);
                if (o != null) {
                    return new Injectable(){

                        public Object getValue() {
                            return o;
                        }
                    };
                }
                return null;
            }
        });
        this.closeableFactory = new CloseableServiceFactory(this.context);
        this.injectableFactory.add(this.closeableFactory);
    }

    @Override
    public WebApplication clone() {
        WebApplicationImpl wa = new WebApplicationImpl();
        wa.initiate(this.resourceConfig, this.provider);
        return wa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClass getResourceClass(Class c) {
        assert (c != null);
        ResourceClass rc = (ResourceClass)this.metaClassMap.get(c);
        if (rc != null) {
            return rc;
        }
        ConcurrentMap<Class, ResourceClass> concurrentMap = this.metaClassMap;
        synchronized (concurrentMap) {
            rc = (ResourceClass)this.metaClassMap.get(c);
            if (rc != null) {
                return rc;
            }
            rc = this.newResourceClass(this.getAbstractResource(c));
            this.metaClassMap.put(c, rc);
            rc.init(this.rcpFactory);
        }
        return rc;
    }

    private ResourceClass getResourceClass(AbstractResource ar) {
        ResourceClass rc = this.newResourceClass(ar);
        this.metaClassMap.put(ar.getResourceClass(), rc);
        rc.init(this.rcpFactory);
        return rc;
    }

    private ResourceClass newResourceClass(AbstractResource ar) {
        assert (null != ar);
        BasicValidator validator = new BasicValidator();
        validator.validate(ar);
        boolean fatalIssueFound = false;
        for (ResourceModelIssue issue : validator.getIssueList()) {
            if (issue.isFatal()) {
                fatalIssueFound = true;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe(issue.getMessage());
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(issue.getMessage());
        }
        if (fatalIssueFound) {
            LOGGER.severe(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
            throw new ContainerException(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
        }
        return new ResourceClass(this.resourceConfig, this.dispatcherFactory, this.injectableFactory, this.filterFactory, this.wadlFactory, ar);
    }

    private AbstractResource getAbstractResource(Object o) {
        return this.getAbstractResource(o.getClass());
    }

    private AbstractResource getAbstractResource(Class c) {
        AbstractResource ar = this.abstractResourceMap.get(c);
        if (ar == null) {
            ar = IntrospectionModeller.createResource(c);
            this.abstractResourceMap.put(c, ar);
        }
        return ar;
    }

    @Override
    public boolean isInitiated() {
        return this.initiated;
    }

    @Override
    public void initiate(ResourceConfig resourceConfig) {
        this.initiate(resourceConfig, null);
    }

    @Override
    public void initiate(ResourceConfig resourceConfig, IoCComponentProviderFactory _provider) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("ResourceConfig instance MUST NOT be null");
        }
        if (this.initiated) {
            throw new ContainerException(ImplMessages.WEB_APP_ALREADY_INITIATED());
        }
        this.initiated = true;
        resourceConfig.validate();
        this.resourceConfig = resourceConfig;
        this.provider = _provider;
        this.providerFactories = new ArrayList<IoCComponentProviderFactory>(2);
        for (Object o : resourceConfig.getProviderSingletons()) {
            if (!(o instanceof IoCComponentProviderFactory)) continue;
            this.providerFactories.add((IoCComponentProviderFactory)o);
        }
        if (_provider != null) {
            this.providerFactories.add(_provider);
        }
        for (IoCComponentProviderFactory f : this.providerFactories) {
            ComponentProcessorFactoryImpl cpf = null;
            if (!(f instanceof IoCComponentProcessorFactoryInitializer)) continue;
            if (cpf == null) {
                cpf = new ComponentProcessorFactoryImpl();
            }
            IoCComponentProcessorFactoryInitializer i = (IoCComponentProcessorFactoryInitializer)((Object)f);
            i.init(cpf);
        }
        this.cpFactory = this.providerFactories.isEmpty() ? new ProviderFactory(this.injectableFactory) : new IoCProviderFactory((InjectableProviderContext)this.injectableFactory, this.providerFactories);
        this.rcpFactory = this.providerFactories.isEmpty() ? new ResourceFactory(this.resourceConfig, this.injectableFactory) : new IoCResourceFactory(this.resourceConfig, this.injectableFactory, this.providerFactories);
        this.resourceContext = new ResourceContext(){

            @Override
            public <T> T getResource(Class<T> c) {
                ResourceClass rc = WebApplicationImpl.this.getResourceClass(c);
                if (rc == null) {
                    LOGGER.severe("No resource class found for class " + c.getName());
                    throw new ContainerException("No resource class found for class " + c.getName());
                }
                Object instance = rc.rcProvider.getInstance(WebApplicationImpl.this.context);
                return instance != null ? (T)c.cast(instance) : null;
            }
        };
        ProviderServices providerServices = new ProviderServices(this.injectableFactory, this.cpFactory, resourceConfig.getProviderClasses(), resourceConfig.getProviderSingletons());
        this.injectableFactory.add(new InjectableProvider<Inject, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Undefined;
            }

            @Override
            public Injectable<Object> getInjectable(ComponentContext ic, Inject a, final Type c) {
                if (!(c instanceof Class)) {
                    return null;
                }
                if (WebApplicationImpl.this.providerFactories.isEmpty()) {
                    return null;
                }
                for (IoCComponentProviderFactory f : WebApplicationImpl.this.providerFactories) {
                    final IoCComponentProvider p = f.getComponentProvider(ic, (Class)c);
                    if (p == null) continue;
                    return new Injectable<Object>(){

                        @Override
                        public Object getValue() {
                            try {
                                return p.getInstance();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Could not get instance from IoC component provider for type " + c, e);
                                throw new ContainerException("Could not get instance from IoC component provider for type " + c, e);
                            }
                        }
                    };
                }
                return null;
            }
        });
        this.injectableFactory.add(new ContextInjectableProvider<ResourceConfig>((Type)((Object)ResourceConfig.class), resourceConfig));
        this.injectableFactory.add(new ContextInjectableProvider<ResourceContext>((Type)((Object)ResourceContext.class), this.resourceContext));
        this.injectableFactory.configure(providerServices);
        final ContextResolverFactory crf = new ContextResolverFactory(providerServices, this.injectableFactory);
        this.templateContext = new TemplateFactory(providerServices);
        this.injectableFactory.add(new ContextInjectableProvider<TemplateContext>((Type)((Object)TemplateContext.class), this.templateContext));
        this.exceptionFactory = new ExceptionMapperFactory(providerServices);
        this.dispatcherFactory = new ResourceMethodDispatcherFactory(providerServices);
        this.bodyFactory = new MessageBodyFactory(providerServices);
        this.injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), this.bodyFactory));
        Providers p = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyWriter(c, t, as, m);
            }

            public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                if (Throwable.class.isAssignableFrom(c)) {
                    return WebApplicationImpl.this.exceptionFactory.find(c);
                }
                return null;
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        this.injectableFactory.add(new ContextInjectableProvider<6>((Type)((Object)Providers.class), p));
        this.bodyFactory.init();
        this.stringReaderFactory = new StringReaderFactory();
        this.injectableFactory.add(new ContextInjectableProvider<StringReaderFactory>((Type)((Object)StringReaderWorkers.class), this.stringReaderFactory));
        this.stringReaderFactory.init(providerServices);
        MultivaluedParameterExtractorFactory mpep = new MultivaluedParameterExtractorFactory(this.stringReaderFactory);
        this.injectableFactory.add(new ContextInjectableProvider<MultivaluedParameterExtractorFactory>((Type)((Object)MultivaluedParameterExtractorProvider.class), mpep));
        this.injectableFactory.add(new CookieParamInjectableProvider(mpep));
        this.injectableFactory.add(new HeaderParamInjectableProvider(mpep));
        this.injectableFactory.add(new HttpContextInjectableProvider());
        this.injectableFactory.add(new MatrixParamInjectableProvider(mpep));
        this.injectableFactory.add(new PathParamInjectableProvider(mpep));
        this.injectableFactory.add(new QueryParamInjectableProvider(mpep));
        this.filterFactory = new FilterFactory(providerServices, resourceConfig);
        this.cpFactory.injectOnAllComponents();
        this.cpFactory.injectOnProviderInstances(resourceConfig.getProviderSingletons());
        this.wadlFactory = new WadlFactory(resourceConfig);
        this.rootsRule = new RootResourceClassesRule(this.processRootResources());
    }

    @Override
    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.bodyFactory;
    }

    @Override
    public void handleRequest(ContainerRequest request, ContainerResponseWriter responseWriter) throws IOException {
        ContainerResponse response = new ContainerResponse(this, request, responseWriter);
        this.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(ContainerRequest request, ContainerResponse response) throws IOException {
        WebApplicationContext localContext = new WebApplicationContext(this, request, response);
        this.context.set(localContext);
        try {
            this._handleRequest(localContext, request, response);
        }
        finally {
            PerRequestFactory.destroy(localContext);
            this.closeableFactory.close(localContext);
            this.context.set(null);
        }
    }

    @Override
    public void destroy() {
        for (ResourceClass rc : this.metaClassMap.values()) {
            rc.destroy();
        }
        this.cpFactory.destroy();
    }

    private void _handleRequest(WebApplicationContext localContext, ContainerRequest request, ContainerResponse response) throws IOException {
        block18: {
            block17: {
                try {
                    for (ContainerRequestFilter containerRequestFilter : this.filterFactory.getRequestFilters()) {
                        request = containerRequestFilter.filter(request);
                        localContext.setContainerRequest(request);
                    }
                    StringBuilder path = new StringBuilder();
                    path.append("/").append(request.getPath(false));
                    if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.IgnoreMatrixParams")) {
                        path = this.stripMatrixParams(path);
                    }
                    if (!this.resourceConfig.getMediaTypeMappings().isEmpty() || !this.resourceConfig.getLanguageMappings().isEmpty()) {
                        this.uriConneg(path, request);
                    }
                    if (!this.rootsRule.accept(path, null, localContext)) {
                        throw new NotFoundException(request.getRequestUri());
                    }
                }
                catch (WebApplicationException e) {
                    this.mapWebApplicationException(e, response);
                }
                catch (MappableContainerException e) {
                    this.mapMappableContainerException(e, response);
                }
                catch (RuntimeException e) {
                    if (this.mapException(e, response)) break block17;
                    throw e;
                }
            }
            try {
                for (ContainerResponseFilter containerResponseFilter : localContext.getResponseFilters()) {
                    response = containerResponseFilter.filter(request, response);
                    localContext.setContainerResponse(response);
                }
                for (ContainerResponseFilter containerResponseFilter : this.filterFactory.getResponseFilters()) {
                    response = containerResponseFilter.filter(request, response);
                    localContext.setContainerResponse(response);
                }
            }
            catch (WebApplicationException e) {
                this.mapWebApplicationException(e, response);
            }
            catch (MappableContainerException e) {
                this.mapMappableContainerException(e, response);
            }
            catch (RuntimeException e) {
                if (this.mapException(e, response)) break block18;
                throw e;
            }
        }
        try {
            response.write();
        }
        catch (WebApplicationException e) {
            if (response.isCommitted()) {
                throw e;
            }
            this.mapWebApplicationException(e, response);
            response.write();
        }
    }

    @Override
    public HttpContext getThreadLocalHttpContext() {
        return this.context;
    }

    private void ensureTemplateUnused(UriTemplate t, AbstractResource ar, Set<UriTemplate> templates) {
        if (templates.contains(t)) {
            LOGGER.severe(ImplMessages.AMBIGUOUS_RR_PATH(ar.getResourceClass(), t));
            throw new ContainerException(ImplMessages.AMBIGUOUS_RR_PATH(ar.getResourceClass(), t));
        }
        templates.add(t);
    }

    private RulesMap<UriRule> processRootResources() {
        PathPattern p;
        PathTemplate t;
        AbstractResource ar;
        Set<Class<?>> classes = this.resourceConfig.getRootResourceClasses();
        Set<Object> singletons = this.resourceConfig.getRootResourceSingletons();
        if (classes.isEmpty() && singletons.isEmpty()) {
            LOGGER.severe(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
            throw new ContainerException(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
        }
        HashMap<Class, AbstractResource> rootResourcesMap = new HashMap<Class, AbstractResource>();
        for (Object object : singletons) {
            rootResourcesMap.put(object.getClass(), this.getAbstractResource(object));
        }
        for (Class clazz : classes) {
            int modifiers = clazz.getModifiers();
            if (Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + clazz + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This class will be ignored");
                continue;
            }
            if (Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + clazz + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This interface will be ignored");
                continue;
            }
            rootResourcesMap.put(clazz, this.getAbstractResource(clazz));
        }
        HashSet<AbstractResource> rootResources = new HashSet<AbstractResource>();
        for (Map.Entry e : rootResourcesMap.entrySet()) {
            rootResources.add((AbstractResource)e.getValue());
        }
        this.initWadl(rootResources, this.wadlFactory);
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        HashSet<UriTemplate> uriTemplatesUsed = new HashSet<UriTemplate>();
        for (Object object : singletons) {
            ComponentInjector ci = new ComponentInjector(this.injectableFactory, object.getClass());
            ci.inject(object);
            ar = (AbstractResource)rootResourcesMap.get(object.getClass());
            t = new PathTemplate(ar.getPath().getValue());
            this.ensureTemplateUnused(t, ar, uriTemplatesUsed);
            p = new PathPattern(t);
            this.getResourceClass(ar);
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceObjectRule(t, object)));
        }
        for (Class clazz : classes) {
            int modifiers = clazz.getModifiers();
            if (Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + clazz + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This class will be ignored");
                continue;
            }
            if (Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + clazz + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This interface will be ignored");
                continue;
            }
            ar = (AbstractResource)rootResourcesMap.get(clazz);
            t = new PathTemplate(ar.getPath().getValue());
            this.ensureTemplateUnused(t, ar, uriTemplatesUsed);
            p = new PathPattern(t);
            this.getResourceClass(ar);
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t, clazz)));
        }
        this.initWadlResource(rulesMap);
        return rulesMap;
    }

    private void initWadl(Set<AbstractResource> rootResources, WadlFactory wadlFactory) {
        if (!wadlFactory.isSupported()) {
            return;
        }
        wadlFactory.init(this.injectableFactory, rootResources);
    }

    private void initWadlResource(RulesMap<UriRule> rulesMap) {
        if (!this.wadlFactory.isSupported()) {
            return;
        }
        PathTemplate t = new PathTemplate("application.wadl");
        PathPattern p = new PathPattern(t);
        if (rulesMap.containsKey(p)) {
            return;
        }
        this.getResourceClass(WadlResource.class);
        rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t, WadlResource.class)));
    }

    private StringBuilder stripMatrixParams(StringBuilder path) {
        int e = path.indexOf(";");
        if (e == -1) {
            return path;
        }
        int s = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(path, s, e);
        } while ((s = path.indexOf("/", e + 1)) != -1 && (e = path.indexOf(";", s)) != -1);
        if (s != -1) {
            sb.append(path, s, path.length());
        }
        return sb;
    }

    private void uriConneg(StringBuilder path, ContainerRequest request) {
        int si = path.lastIndexOf("/");
        if (si == path.length() - 1) {
            si = path.lastIndexOf("/", si - 1);
        }
        if (si == -1) {
            si = 0;
        }
        MediaType accept = null;
        for (Map.Entry<String, MediaType> e : this.resourceConfig.getMediaTypeMappings().entrySet()) {
            int i = path.indexOf(e.getKey(), si);
            if (i <= 0 || path.charAt(i - 1) != '.') continue;
            int lengthWithExt = i + e.getKey().length();
            if (lengthWithExt == path.length()) {
                accept = e.getValue();
                path.delete(i - 1, lengthWithExt);
                continue;
            }
            char charAfterExt = path.charAt(lengthWithExt);
            if ('/' != charAfterExt && '.' != charAfterExt) continue;
            accept = e.getValue();
            path.delete(i - 1, lengthWithExt);
        }
        if (accept != null) {
            MultivaluedMap<String, String> h = request.getRequestHeaders();
            h.putSingle((Object)"Accept", (Object)accept.toString());
        }
        String acceptLanguage = null;
        for (Map.Entry<String, String> e : this.resourceConfig.getLanguageMappings().entrySet()) {
            int i = path.indexOf(e.getKey(), si);
            if (i <= 0 || path.charAt(i - 1) != '.') continue;
            acceptLanguage = e.getValue();
            path.delete(i - 1, i + e.getKey().length());
        }
        if (acceptLanguage != null) {
            MultivaluedMap<String, String> h = request.getRequestHeaders();
            h.putSingle((Object)"Accept-Language", acceptLanguage);
        }
    }

    private <T> T createProxy(Class<T> c, InvocationHandler i) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c}, i);
    }

    private void mapMappableContainerException(MappableContainerException e, HttpResponseContext response) {
        Throwable cause = e.getCause();
        if (cause instanceof WebApplicationException) {
            this.mapWebApplicationException((WebApplicationException)cause, response);
        } else if (!this.mapException(cause, response)) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    private void mapWebApplicationException(WebApplicationException e, HttpResponseContext response) {
        if (e.getResponse().getEntity() != null) {
            WebApplicationImpl.onException(e, e.getResponse(), response);
        } else if (!this.mapException(e, response)) {
            WebApplicationImpl.onException(e, e.getResponse(), response);
        }
    }

    private boolean mapException(Throwable e, HttpResponseContext response) {
        ExceptionMapper em = this.exceptionFactory.find(e.getClass());
        if (em == null) {
            return false;
        }
        try {
            Response r = em.toResponse(e);
            if (r == null) {
                r = Response.noContent().build();
            }
            WebApplicationImpl.onException(e, r, response);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("Exception mapper " + em + " for throwable " + e + " threw a Runtime exception when " + "attempting to obtain the response");
            Response r = Response.serverError().build();
            WebApplicationImpl.onException(ex, r, response);
        }
        return true;
    }

    private static void onException(Throwable e, Response r, HttpResponseContext response) {
        if (r.getStatus() >= 500) {
            LOGGER.log(Level.SEVERE, "Internal server error", e);
        }
        if (r.getStatus() >= 500 && r.getEntity() == null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            r = Response.status((int)r.getStatus()).entity((Object)sw.toString()).type("text/plain").build();
        }
        response.setResponse(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }

    private class ComponentProcessorFactoryImpl
    implements IoCComponentProcessorFactory {
        private final ConcurrentMap<Class, IoCComponentProcessor> componentProcessorMap = new ConcurrentHashMap<Class, IoCComponentProcessor>();

        private ComponentProcessorFactoryImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IoCComponentProcessor get(Class c, ComponentScope scope) {
            IoCComponentProcessor cp = (IoCComponentProcessor)this.componentProcessorMap.get(c);
            if (cp != null) {
                return cp;
            }
            ConcurrentMap concurrentMap = WebApplicationImpl.this.metaClassMap;
            synchronized (concurrentMap) {
                cp = (IoCComponentProcessor)this.componentProcessorMap.get(c);
                if (cp != null) {
                    return cp;
                }
                cp = new ComponentProcessorImpl(scope, WebApplicationImpl.this.getAbstractResource(c));
                this.componentProcessorMap.put(c, cp);
            }
            return cp;
        }
    }

    private class ComponentProcessorImpl
    implements IoCComponentProcessor {
        private final ResourceComponentInjector rci;

        ComponentProcessorImpl(ComponentScope s, AbstractResource resource) {
            this.rci = new ResourceComponentInjector(WebApplicationImpl.this.injectableFactory, s, resource);
        }

        public void preConstruct() {
        }

        public void postConstruct(Object o) {
            this.rci.inject(WebApplicationImpl.this.context.get(), o);
        }
    }
}

