/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.reader;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class JsonReaderXmlEvent {
    Location location;
    QName name;
    String text;
    List<Attribute> attributes;
    boolean attributesChecked;

    public abstract int getEventType();

    public boolean isAttribute() {
        return false;
    }

    public boolean isCharacters() {
        return false;
    }

    public boolean isEndDocument() {
        return false;
    }

    public boolean isEndElement() {
        return false;
    }

    public boolean isEntityReference() {
        return false;
    }

    public boolean isNamespace() {
        return false;
    }

    public boolean isProcessingInstruction() {
        return false;
    }

    public boolean isStartDocument() {
        return false;
    }

    public boolean isStartElement() {
        return false;
    }

    public int getAttributeCount() {
        return null != this.attributes ? this.attributes.size() : 0;
    }

    public String getAttributeLocalName(int index) {
        if (null == this.attributes || index >= this.attributes.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes.get((int)index).name;
    }

    public QName getAttributeName(int index) {
        return new QName(null, this.getAttributeLocalName(index));
    }

    public String getAttributePrefix(int index) {
        if (null == this.attributes || index >= this.attributes.size()) {
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    public String getAttributeType(int index) {
        return null;
    }

    public String getAttributeNamespace(int index) {
        return null;
    }

    public String getAttributeValue(int index) {
        if (null == this.attributes || index >= this.attributes.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes.get((int)index).value;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (null == this.attributes || null == localName || "".equals(localName)) {
            throw new NoSuchElementException();
        }
        for (Attribute a : this.attributes) {
            if (!localName.equals(a.name)) continue;
            return a.value;
        }
        throw new NoSuchElementException();
    }

    public boolean isAttributeSpecified(int index) {
        return null != this.attributes && this.attributes.size() >= index;
    }

    public String getText() {
        if (null != this.text) {
            return this.text;
        }
        throw new IllegalStateException();
    }

    public char[] getTextCharacters() {
        if (null != this.text) {
            return this.text.toCharArray();
        }
        throw new IllegalStateException();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (null != this.text) {
            System.arraycopy(this.text.toCharArray(), sourceStart, target, targetStart, length);
            return length;
        }
        throw new IllegalStateException();
    }

    public int getTextStart() {
        if (null != this.text) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public int getTextLength() {
        if (null != this.text) {
            return this.text.length();
        }
        throw new IllegalStateException();
    }

    public boolean hasName() {
        return null != this.name;
    }

    public QName getName() {
        if (null != this.name) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        if (null != this.name) {
            return this.name.getLocalPart();
        }
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        if (null != this.name) {
            return this.name.getPrefix();
        }
        return null;
    }

    public Location getLocation() {
        return this.location;
    }

    public void addAttribute(String name, String value) {
        if (null == this.attributes) {
            this.attributes = new LinkedList<Attribute>();
        }
        this.attributes.add(new Attribute(name, value));
    }

    public static class Attribute {
        String name;
        String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

