/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.reader;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonReadContext;
import org.codehaus.jackson.JsonToken;

public class JacksonRootAddingParser
extends JsonParser {
    String rootName;
    JsonParser parser;
    JsonToken currentToken;
    State state;

    public static JsonParser createRootAddingParser(JsonParser parser, String rootName) {
        return new JacksonRootAddingParser(parser, rootName);
    }

    private JacksonRootAddingParser() {
    }

    private JacksonRootAddingParser(JsonParser parser, String rootName) {
        this.parser = parser;
        this.state = State.START;
        this.rootName = rootName;
    }

    public void enableFeature(JsonParser.Feature feature) {
        this.parser.enableFeature(feature);
    }

    public void disableFeature(JsonParser.Feature feature) {
        this.parser.disableFeature(feature);
    }

    public void setFeature(JsonParser.Feature feature, boolean isSet) {
        this.parser.setFeature(feature, isSet);
    }

    public boolean isFeatureEnabled(JsonParser.Feature feature) {
        return this.parser.isFeatureEnabled(feature);
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        switch (this.state) {
            case START: {
                this.state = State.AFTER_SO;
                this.currentToken = JsonToken.START_OBJECT;
                return this.currentToken;
            }
            case AFTER_SO: {
                this.state = State.AFTER_FN;
                this.currentToken = JsonToken.FIELD_NAME;
                return this.currentToken;
            }
            case AFTER_FN: {
                this.state = State.INNER;
            }
            case INNER: {
                this.currentToken = this.parser.nextToken();
                if (this.currentToken == null) {
                    this.state = State.END;
                    this.currentToken = JsonToken.END_OBJECT;
                }
                return this.currentToken;
            }
        }
        this.currentToken = null;
        return this.currentToken;
    }

    public void skipChildren() throws IOException, JsonParseException {
        this.parser.skipChildren();
    }

    public JsonToken getCurrentToken() {
        switch (this.state) {
            case START: {
                return null;
            }
            case AFTER_SO: {
                return this.currentToken;
            }
            case AFTER_FN: {
                return this.currentToken;
            }
        }
        return this.currentToken;
    }

    public boolean hasCurrentToken() {
        switch (this.state) {
            case START: {
                return false;
            }
            case AFTER_SO: {
                return true;
            }
            case AFTER_FN: {
                return true;
            }
        }
        return this.currentToken != null;
    }

    public String getCurrentName() throws IOException, JsonParseException {
        switch (this.state) {
            case START: {
                return null;
            }
            case AFTER_SO: {
                return null;
            }
            case AFTER_FN: {
                return this.rootName;
            }
            case INNER: {
                return this.parser.getCurrentName();
            }
        }
        return null;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public JsonReadContext getParsingContext() {
        return this.parser.getParsingContext();
    }

    public JsonLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this.parser.getCurrentLocation();
    }

    public String getText() throws IOException, JsonParseException {
        return this.parser.getText();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.parser.getTextCharacters();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.parser.getTextLength();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return this.parser.getTextOffset();
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return this.parser.getNumberValue();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        return this.parser.getNumberType();
    }

    public int getIntValue() throws IOException, JsonParseException {
        return this.parser.getIntValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this.parser.getLongValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this.parser.getDoubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return this.parser.getDecimalValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START,
        AFTER_SO,
        AFTER_FN,
        INNER,
        END;

    }
}

