/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl;

import com.sun.jersey.api.json.JSONConfigurated;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.Stax2JsonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONMarshaller
implements Marshaller,
JSONConfigurated {
    private final JAXBContext jaxbContext;
    private final Marshaller jaxbMarshaller;
    private boolean jsonEnabled;
    private final JSONConfiguration jsonConfig;

    public JSONMarshaller(JAXBContext jaxbContext, JSONConfiguration jsonConfig) throws JAXBException {
        this.jaxbContext = jaxbContext;
        this.jsonConfig = jsonConfig;
        this.jaxbMarshaller = jaxbContext.createMarshaller();
    }

    public void marshal(Object jaxbObject, Result result) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, result);
    }

    public void marshal(Object jaxbObject, OutputStream os) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                XMLStreamWriter xsw = this.createXmlStreamWriter(new OutputStreamWriter(os, this.getCharset()));
                this.jaxbMarshaller.marshal(jaxbObject, xsw);
                xsw.flush();
            }
            catch (XMLStreamException ex) {
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, os);
        }
    }

    public void marshal(Object jaxbObject, File file) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                XMLStreamWriter xsw = this.createXmlStreamWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getCharset()));
                this.jaxbMarshaller.marshal(jaxbObject, xsw);
                xsw.flush();
            }
            catch (Exception ex) {
                Logger.getLogger(JSONMarshaller.class.getName()).log(Level.SEVERE, "IOException caught when marshalling into a file.", ex);
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, file);
        }
    }

    public void marshal(Object jaxbObject, Writer writer) throws JAXBException {
        if (this.jsonEnabled) {
            XMLStreamWriter xsw = this.createXmlStreamWriter(writer);
            this.jaxbMarshaller.marshal(jaxbObject, xsw);
            try {
                xsw.flush();
            }
            catch (XMLStreamException ex) {
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, writer);
        }
    }

    public void marshal(Object jaxbObject, ContentHandler handler) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, handler);
    }

    public void marshal(Object jaxbObject, Node node) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, node);
    }

    public void marshal(Object jaxbObject, XMLStreamWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public void marshal(Object jaxbObject, XMLEventWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public Node getNode(Object jaxbObject) throws JAXBException {
        return this.jaxbMarshaller.getNode(jaxbObject);
    }

    public void setProperty(String key, Object value) throws PropertyException {
        this.jaxbMarshaller.setProperty(key, value);
    }

    public boolean isJsonEnabled() {
        return this.jsonEnabled;
    }

    public void setJsonEnabled(boolean jsonEnabled) {
        this.jsonEnabled = jsonEnabled;
    }

    public Object getProperty(String key) throws PropertyException {
        return this.jaxbMarshaller.getProperty(key);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.jaxbMarshaller.setEventHandler(handler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.jaxbMarshaller.getEventHandler();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.jaxbMarshaller.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.jaxbMarshaller.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.jaxbMarshaller.getAdapter(type);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller marshaller) {
        this.jaxbMarshaller.setAttachmentMarshaller(marshaller);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.jaxbMarshaller.getAttachmentMarshaller();
    }

    public void setSchema(Schema schema) {
        this.jaxbMarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.jaxbMarshaller.getSchema();
    }

    public void setListener(Marshaller.Listener listener) {
        this.jaxbMarshaller.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.jaxbMarshaller.getListener();
    }

    private void setProperties(Map<String, Object> properties) throws PropertyException {
        if (null != properties) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private XMLStreamWriter createXmlStreamWriter(Writer writer) throws JAXBException {
        try {
            return Stax2JsonFactory.createWriter(writer, this.jsonConfig);
        }
        catch (IOException ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Charset getCharset() throws JAXBException {
        String charset = (String)this.jaxbMarshaller.getProperty("jaxb.encoding");
        return charset == null ? Charset.forName("UTF-8") : Charset.forName(charset);
    }

    @Override
    public JSONConfiguration getJSONConfiguration() {
        return this.jsonConfig;
    }
}

