/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.factory;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.util.KeyComparator;
import com.sun.jersey.core.util.KeyComparatorHashMap;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBodyFactory
implements MessageBodyWorkers {
    private static final KeyComparator<MediaType> MEDIA_TYPE_COMPARATOR = new KeyComparator<MediaType>(){

        @Override
        public boolean equals(MediaType x, MediaType y) {
            return x.getType().equalsIgnoreCase(y.getType()) && x.getSubtype().equalsIgnoreCase(y.getSubtype());
        }

        @Override
        public int hash(MediaType k) {
            return k.getType().toLowerCase().hashCode() + k.getSubtype().toLowerCase().hashCode();
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private final ProviderServices providerServices;
    private Map<MediaType, List<MessageBodyReader>> readerProviders;
    private Map<MediaType, List<MessageBodyWriter>> writerProviders;
    private List<MessageBodyWriterPair> writerListProviders;

    public MessageBodyFactory(ProviderServices providerServices) {
        this.providerServices = providerServices;
    }

    public void init() {
        this.initReaders();
        this.initWriters();
    }

    private void initReaders() {
        this.readerProviders = this.getProviderMap(MessageBodyReader.class, Consumes.class);
    }

    private void initWriters() {
        this.writerProviders = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.writerListProviders = new ArrayList<MessageBodyWriterPair>();
        for (MessageBodyWriter provider : this.providerServices.getProvidersAndServices(MessageBodyWriter.class)) {
            MediaType[] values = this.getAnnotationValues(provider.getClass(), Produces.class);
            if (values == null) {
                this.getClassCapability(this.writerProviders, provider, MediaTypes.GENERAL_MEDIA_TYPE);
            } else {
                for (MediaType type : values) {
                    this.getClassCapability(this.writerProviders, provider, type);
                }
            }
            this.writerListProviders.add(new MessageBodyWriterPair(provider, values));
        }
    }

    private <T> Map<MediaType, List<T>> getProviderMap(Class<T> serviceClass, Class<?> annotationClass) {
        KeyComparatorHashMap<MediaType, List<T>> s = new KeyComparatorHashMap<MediaType, List<T>>(MEDIA_TYPE_COMPARATOR);
        for (T provider : this.providerServices.getProvidersAndServices(serviceClass)) {
            MediaType[] values = this.getAnnotationValues(provider.getClass(), annotationClass);
            if (values == null) {
                this.getClassCapability(s, provider, MediaTypes.GENERAL_MEDIA_TYPE);
                continue;
            }
            for (MediaType type : values) {
                this.getClassCapability(s, provider, type);
            }
        }
        return s;
    }

    private <T> void getClassCapability(Map<MediaType, List<T>> capabilities, T provider, MediaType mediaType) {
        if (!capabilities.containsKey(mediaType)) {
            capabilities.put(mediaType, new ArrayList());
        }
        List<T> providers = capabilities.get(mediaType);
        providers.add(provider);
    }

    private MediaType[] getAnnotationValues(Class<?> clazz, Class<?> annotationClass) {
        String[] mts = this._getAnnotationValues(clazz, annotationClass);
        if (mts == null) {
            MediaType[] mt = new MediaType[]{MediaTypes.GENERAL_ACCEPT_MEDIA_TYPE};
            return mt;
        }
        MediaType[] mt = new MediaType[mts.length];
        for (int i = 0; i < mts.length; ++i) {
            mt[i] = MediaType.valueOf((String)mts[i]);
        }
        return mt;
    }

    private String[] _getAnnotationValues(Class<?> clazz, Class<?> annotationClass) {
        Produces produces;
        String[] values = null;
        if (annotationClass.equals(Consumes.class)) {
            Consumes consumes = clazz.getAnnotation(Consumes.class);
            if (consumes != null) {
                values = consumes.value();
            }
        } else if (annotationClass.equals(Produces.class) && (produces = clazz.getAnnotation(Produces.class)) != null) {
            values = produces.value();
        }
        return values;
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyReader<T> p = null;
        if (mediaType != null && (p = this._getMessageBodyReader(c, t, as, mediaType, mediaType)) == null) {
            p = this._getMessageBodyReader(c, t, as, mediaType, new MediaType(mediaType.getType(), "*"));
        }
        if (p == null) {
            p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
        }
        return p;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyReader> readers = this.readerProviders.get(lookup);
        if (readers == null) {
            return null;
        }
        for (MessageBodyReader p : readers) {
            if (!p.isReadable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyWriter<T> p = null;
        if (mediaType != null && (p = this._getMessageBodyWriter(c, t, as, mediaType, mediaType)) == null) {
            p = this._getMessageBodyWriter(c, t, as, mediaType, new MediaType(mediaType.getType(), "*"));
        }
        if (p == null) {
            p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
        }
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyWriter> writers = this.writerProviders.get(lookup);
        if (writers == null) {
            return null;
        }
        for (MessageBodyWriter p : writers) {
            if (!p.isWriteable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T> List<MediaType> getMessageBodyWriterMediaTypes(Class<T> c, Type t, Annotation[] as) {
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (MessageBodyWriterPair mbwp : this.writerListProviders) {
            if (!mbwp.mbw.isWriteable(c, t, as, MediaType.APPLICATION_OCTET_STREAM_TYPE)) continue;
            for (MediaType mt : mbwp.types) {
                mtl.add(mt);
            }
        }
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    @Override
    public <T> MediaType getMessageBodyWriterMediaType(Class<T> c, Type t, Annotation[] as, List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptable : acceptableMediaTypes) {
            for (MessageBodyWriterPair mbwp : this.writerListProviders) {
                for (MediaType mt : mbwp.types) {
                    if (!mt.isCompatible(acceptable) || !mbwp.mbw.isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
        }
        return null;
    }

    private static class MessageBodyWriterPair {
        final MessageBodyWriter mbw;
        final MediaType[] types;

        MessageBodyWriterPair(MessageBodyWriter mbw, MediaType[] types) {
            this.mbw = mbw;
            this.types = types;
        }
    }
}

