/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.core;

import com.sun.jersey.core.util.FeaturesAndProperties;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceConfig
extends Application
implements FeaturesAndProperties {
    private static final Logger LOGGER = Logger.getLogger(ResourceConfig.class.getName());
    public static final String FEATURE_NORMALIZE_URI = "com.sun.jersey.config.feature.NormalizeURI";
    public static final String FEATURE_CANONICALIZE_URI_PATH = "com.sun.jersey.config.feature.CanonicalizeURIPath";
    public static final String FEATURE_REDIRECT = "com.sun.jersey.config.feature.Redirect";
    public static final String FEATURE_MATCH_MATRIX_PARAMS = "com.sun.jersey.config.feature.IgnoreMatrixParams";
    public static final String FEATURE_IMPLICIT_VIEWABLES = "com.sun.jersey.config.feature.ImplicitViewables";
    public static final String PROPERTY_DEFAULT_RESOURCE_COMPONENT_PROVIDER_FACTORY_CLASS = "com.sun.jersey.config.property.DefaultResourceComponentProviderFactoryClass";
    public static final String PROPERTY_CONTAINER_NOTIFIER = "com.sun.jersey.spi.container.ContainerNotifier";
    public static final String PROPERTY_CONTAINER_REQUEST_FILTERS = "com.sun.jersey.spi.container.ContainerRequestFilters";
    public static final String PROPERTY_CONTAINER_RESPONSE_FILTERS = "com.sun.jersey.spi.container.ContainerResponseFilters";
    public static final String PROPERTY_RESOURCE_FILTER_FACTORIES = "com.sun.jersey.spi.container.ResourceFilters";
    public static final String PROPERTY_WADL_GENERATOR_CONFIG = "com.sun.jersey.config.property.WadlGeneratorConfig";

    @Override
    public abstract Map<String, Boolean> getFeatures();

    @Override
    public abstract boolean getFeature(String var1);

    @Override
    public abstract Map<String, Object> getProperties();

    @Override
    public abstract Object getProperty(String var1);

    public Map<String, MediaType> getMediaTypeMappings() {
        return Collections.emptyMap();
    }

    public Map<String, String> getLanguageMappings() {
        return Collections.emptyMap();
    }

    public void validate() {
        Class c;
        Iterator i = this.getClasses().iterator();
        while (i.hasNext()) {
            c = (Class)i.next();
            for (Object o : this.getSingletons()) {
                if (!c.isInstance(o)) continue;
                i.remove();
                LOGGER.log(Level.WARNING, "Class " + c.getName() + " is ignored as an instance is registered in the set of singletons");
            }
        }
        i = this.getClasses().iterator();
        while (i.hasNext()) {
            c = (Class)i.next();
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                LOGGER.warning("The abstract " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This class will be ignored");
                i.remove();
                continue;
            }
            if (!Modifier.isInterface(modifiers)) continue;
            LOGGER.warning("The " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This interface will be ignored");
            i.remove();
        }
        HashSet objectClassSet = new HashSet();
        HashSet conflictSet = new HashSet();
        for (Object e : this.getSingletons()) {
            if (!e.getClass().isAnnotationPresent(Path.class)) continue;
            if (objectClassSet.contains(e.getClass())) {
                conflictSet.add(e.getClass());
                continue;
            }
            objectClassSet.add(e.getClass());
        }
        if (!conflictSet.isEmpty()) {
            for (Class clazz : conflictSet) {
                LOGGER.log(Level.SEVERE, "Root resource class " + clazz.getName() + " is instantated more than once in the set of registered singletons");
            }
            throw new IllegalArgumentException("The set of registered singletons contains more than one instance of the same root resource class");
        }
    }

    public Set<Class<?>> getRootResourceClasses() {
        HashSet<Class> s = new HashSet<Class>();
        for (Class c : this.getClasses()) {
            if (!ResourceConfig.isRootResourceClass(c)) continue;
            s.add(c);
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<Class<?>> getProviderClasses() {
        HashSet<Class> s = new HashSet<Class>();
        for (Class c : this.getClasses()) {
            if (c.isAnnotationPresent(Path.class)) continue;
            s.add(c);
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<Object> getRootResourceSingletons() {
        HashSet s = new HashSet();
        for (Object o : this.getSingletons()) {
            if (!ResourceConfig.isRootResourceClass(o.getClass())) continue;
            s.add(o);
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<Object> getProviderSingletons() {
        HashSet s = new HashSet();
        for (Object o : this.getSingletons()) {
            if (o.getClass().isAnnotationPresent(Path.class)) continue;
            s.add(o);
        }
        return Collections.unmodifiableSet(s);
    }

    public static boolean isRootResourceClass(Class<?> c) {
        if (c == null) {
            return false;
        }
        if (c.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Class<?> i : c.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProviderClass(Class<?> c) {
        if (c == null) {
            return false;
        }
        return c.isAnnotationPresent(Provider.class);
    }

    public void setPropertiesAndFeatures(Map<String, Object> entries) {
        for (Map.Entry<String, Object> e : entries.entrySet()) {
            if (!this.getProperties().containsKey(e.getKey())) {
                this.getProperties().put(e.getKey(), e.getValue());
            }
            if (this.getFeatures().containsKey(e.getKey())) continue;
            Object v = e.getValue();
            if (v instanceof String) {
                String sv = ((String)v).trim();
                if (sv.equalsIgnoreCase("true")) {
                    this.getFeatures().put(e.getKey(), true);
                    continue;
                }
                if (!sv.equalsIgnoreCase("false")) continue;
                this.getFeatures().put(e.getKey(), false);
                continue;
            }
            if (!(v instanceof Boolean)) continue;
            this.getFeatures().put(e.getKey(), (Boolean)v);
        }
    }
}

