/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri;

import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.Comparator;

public final class PathPattern
extends UriPattern {
    public static final PathPattern EMPTY_PATH = new PathPattern();
    public static final Comparator<PathPattern> COMPARATOR = new Comparator<PathPattern>(){

        @Override
        public int compare(PathPattern o1, PathPattern o2) {
            return UriTemplate.COMPARATOR.compare(o1.template, o2.template);
        }
    };
    private static final String LIMITED = "(/.*)?";
    private static final String UNLIMITED = "(/)?";
    private final UriTemplate template;

    private PathPattern() {
        super("");
        this.template = UriTemplate.EMPTY;
    }

    public PathPattern(UriTemplate template, boolean limited) {
        super(PathPattern.postfixWithCapturingGroup(template.getPattern().getRegex(), limited));
        this.template = template;
    }

    public UriTemplate getTemplate() {
        return this.template;
    }

    private static String postfixWithCapturingGroup(String regex, boolean limited) {
        if (regex.endsWith("/")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        return regex + (limited ? LIMITED : UNLIMITED);
    }
}

