/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.model;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.impl.ImplMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionHelper {
    public static <A> A getAnnotiationType(Class<A> c, Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].annotationType() != c) continue;
            return (A)annotations[i];
        }
        return null;
    }

    public static boolean hasAnnotation(Class<?> c, Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (a.annotationType() != c) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Class<?> c, Annotation[] annotations, Class<?> declaringClass, AccessibleObject ao) {
        if (ReflectionHelper.hasAnnotation(c, annotations)) {
            return true;
        }
        if (ReflectionHelper.hasAnnotation(c, ao.getDeclaredAnnotations())) {
            return true;
        }
        return ReflectionHelper.hasAnnotation(c, declaringClass.getDeclaredAnnotations());
    }

    public static Class getGenericClass(Type parameterType) {
        if (!(parameterType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)parameterType;
        Type[] genericTypes = type.getActualTypeArguments();
        if (genericTypes.length != 1) {
            return null;
        }
        Type genericType = genericTypes[0];
        if (genericType instanceof Class) {
            return (Class)genericTypes[0];
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Type t = arrayType.getGenericComponentType();
            if (t instanceof Class) {
                Class c = (Class)t;
                try {
                    Object o = Array.newInstance(c, 0);
                    return o.getClass();
                }
                catch (Exception e) {
                    throw new ContainerException(e);
                }
            }
            throw new ContainerException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(genericType, parameterType));
        }
        throw new ContainerException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(genericType, parameterType));
    }

    public static Method getValueOfStringMethod(Class c) {
        try {
            Method m = c.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers())) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getStringConstructor(Class c) {
        try {
            return c.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv) {
        return ReflectionHelper.resolveTypeVariable(c, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        ParameterizedType pt = (ParameterizedType)c.getGenericSuperclass();
        Type[] typeArguments = pt.getActualTypeArguments();
        Class sc = c.getSuperclass();
        TypeVariable<Class<T>>[] typeParameters = sc.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t = map.get(typeArguments[i]);
                submap.put(typeParameters[i], t);
                continue;
            }
            submap.put(typeParameters[i], typeArguments[i]);
        }
        if (sc == dc) {
            Type t = (Type)submap.get(tv);
            if (t instanceof Class) {
                return new ClassTypePair((Class)t);
            }
            if (t instanceof GenericArrayType) {
                if ((t = ((GenericArrayType)t).getGenericComponentType()) instanceof Class) {
                    c = (Class)t;
                    try {
                        Object o = Array.newInstance(c, 0);
                        return new ClassTypePair(o.getClass());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t instanceof ParameterizedType) {
                pt = (ParameterizedType)t;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return ReflectionHelper.resolveTypeVariable(sc, dc, tv, submap);
    }

    public static class ClassTypePair {
        public final Class c;
        public final Type t;

        ClassTypePair(Class c) {
            this(c, c);
        }

        ClassTypePair(Class c, Type t) {
            this.c = c;
            this.t = t;
        }
    }
}

