/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.service.ComponentConstructor;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.service.ServiceFinder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentProviderCache {
    private static final Logger LOGGER = Logger.getLogger(ComponentProviderCache.class.getName());
    private final InjectableProviderFactory injectableFactory;
    private final ComponentProvider componentProvider;
    private final Set<Class<?>> providers;
    private final Set<?> providerInstances;
    private final Map<Class, Object> cache;

    public ComponentProviderCache(InjectableProviderFactory injectableFactory, ComponentProvider componentProvider, Set<Class<?>> providers, Set<?> providerInstances) {
        this.injectableFactory = injectableFactory;
        this.componentProvider = componentProvider;
        this.providers = providers;
        this.providerInstances = providerInstances;
        this.cache = new HashMap<Class, Object>();
        for (Object p : providerInstances) {
            this.cache.put(p.getClass(), p);
        }
    }

    public ComponentProvider getComponentProvider() {
        return this.componentProvider;
    }

    public <T> Set<T> getProviders(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> Set<T> getServices(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        for (Class pc : this.getServiceClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> Set<T> getProvidersAndServices(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderAndServiceClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> List<T> getInstances(Class<T> provider, String[] classNames) {
        LinkedList<T> ps = new LinkedList<T>();
        for (String className : classNames) {
            try {
                Class<?> c = Class.forName(className, true, this.getClassLoader());
                if (provider.isAssignableFrom(c)) {
                    Object o = this.getComponent(c);
                    if (o == null) continue;
                    ps.add(provider.cast(o));
                    continue;
                }
                LOGGER.severe("The class " + className + " is not assignable to the class " + provider.getName() + ". This class is ignored.");
            }
            catch (ClassNotFoundException e) {
                LOGGER.severe("The class " + className + " could not be found" + ". This class is ignored.");
            }
        }
        return ps;
    }

    public void injectOnComponents() {
        for (Object v : this.cache.values()) {
            this.componentProvider.inject(v);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        if (l == null) {
            l = ClassLoader.getSystemClassLoader();
        }
        return l;
    }

    private Object getComponent(Class<?> provider) {
        Object o = this.cache.get(provider);
        if (o != null) {
            return o;
        }
        try {
            ComponentConstructor cc = new ComponentConstructor(this.injectableFactory);
            ComponentConstructor.ConstructorInjectablePair<?> cip = cc.getConstructor(provider);
            if (cip == null || cip.is.size() == 0) {
                o = this.componentProvider.getInstance(ComponentProvider.Scope.Singleton, provider);
            } else {
                Object[] params = new Object[cip.is.size()];
                int i = 0;
                for (Injectable injectable : cip.is) {
                    if (injectable == null) continue;
                    params[i++] = injectable.getValue(null);
                }
                o = this.componentProvider.getInstance(ComponentProvider.Scope.Singleton, cip.con, params);
            }
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.log(Level.CONFIG, "A dependent class, " + ex.getLocalizedMessage() + ", of the component " + provider + " is not found." + " The component is ignored.");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getLocalizedMessage());
            LOGGER.log(Level.CONFIG, "The provider class, " + provider + ", could not be instantiated");
            return null;
        }
        this.cache.put(provider, o);
        return o;
    }

    private <T> Set<T> getProviderInstances(Class<T> service) {
        LinkedHashSet<T> sp = new LinkedHashSet<T>();
        for (Object p : this.providerInstances) {
            if (!service.isInstance(p)) continue;
            sp.add(service.cast(p));
        }
        return sp;
    }

    private Set<Class> getProviderClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>();
        for (Class<?> p : this.providers) {
            if (!service.isAssignableFrom(p)) continue;
            sp.add(p);
        }
        return sp;
    }

    private Set<Class> getProviderAndServiceClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>(this.getProviderClasses(service));
        this.getServiceClasses(service, sp);
        return sp;
    }

    private Set<Class> getServiceClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>();
        this.getServiceClasses(service, sp);
        return sp;
    }

    private void getServiceClasses(Class<?> service, Set<Class> sp) {
        Class<?>[] pca;
        LOGGER.log(Level.CONFIG, "Searching for providers that implement: " + service);
        for (Class<?> pc : pca = ServiceFinder.find(service, true).toClassArray()) {
            LOGGER.log(Level.CONFIG, "    Provider found: " + pc);
        }
        for (Class<?> pc : pca) {
            sp.add(pc);
        }
    }
}

