/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.core;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.impl.container.config.AnnotatedClassScanner;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathResourceConfig
extends DefaultResourceConfig {
    public static final String PROPERTY_CLASSPATH = "com.sun.jersey.config.property.classpath";
    private static final Logger LOGGER = Logger.getLogger(ClasspathResourceConfig.class.getName());
    private final String[] paths;

    public ClasspathResourceConfig() {
        this(ClasspathResourceConfig.getPaths());
    }

    public ClasspathResourceConfig(Map<String, Object> props) {
        this(ClasspathResourceConfig.getPaths(props));
        this.setPropertiesAndFeatures(props);
    }

    public ClasspathResourceConfig(String[] paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Array of paths must not be null or empty");
        }
        this.paths = (String[])paths.clone();
        this.init(paths);
    }

    public void reload() {
        this.getResourceClasses().clear();
        this.getProviderClasses().clear();
        this.init(this.paths);
    }

    private void init(String[] paths) {
        File[] roots = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            roots[i] = new File(paths[i]);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder b = new StringBuilder();
            b.append("Scanning for root resource and provider classes in the paths:");
            for (String p : paths) {
                b.append('\n').append("  ").append(p);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
        AnnotatedClassScanner scanner = new AnnotatedClassScanner(Path.class, Provider.class);
        scanner.scan(roots);
        this.getResourceClasses().addAll(scanner.getMatchingClasses(Path.class));
        this.getProviderClasses().addAll(scanner.getMatchingClasses(Provider.class));
        if (LOGGER.isLoggable(Level.INFO) && !this.getResourceClasses().isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Root resource classes found:");
            for (Class<?> c : this.getResourceClasses()) {
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
            b = new StringBuilder();
            b.append("Provider classes found:");
            for (Class<?> c : this.getProviderClasses()) {
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
    }

    private static String[] getPaths() {
        String classPath = System.getProperty("java.class.path");
        return classPath.split(File.pathSeparator);
    }

    private static String[] getPaths(Map<String, Object> props) {
        Object v = props.get(PROPERTY_CLASSPATH);
        if (v == null) {
            throw new IllegalArgumentException("com.sun.jersey.config.property.classpath property is missing");
        }
        String[] paths = ClasspathResourceConfig.getPaths(v);
        if (paths.length == 0) {
            throw new IllegalArgumentException("com.sun.jersey.config.property.classpath contains no paths");
        }
        return paths;
    }

    private static String[] getPaths(Object param) {
        if (param instanceof String) {
            return ClasspathResourceConfig.getElements(new String[]{(String)param});
        }
        if (param instanceof String[]) {
            return ClasspathResourceConfig.getElements((String[])param);
        }
        throw new IllegalArgumentException("com.sun.jersey.config.property.classpath must have a property value of type String or String[]");
    }
}

