/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.view.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.ViewResource;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.WebResourceLinkHeaders;
import com.sun.jersey.client.view.annotation.Required;
import com.sun.jersey.client.view.exception.ClientRuntimeException;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Context;

public class ArgumentInjector {
    public static Object[] makeArgs(Client client, AnnotatedMethod m, ClientResponse cr, URI uri) {
        Class[] parameterTypes = m.getParameterTypes();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        Object[] args = new Object[parameterTypes.length];
        boolean haveEntityParam = false;
        boolean responseOrOutputStreamInjected = false;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            if (annotations.length == 0) {
                if (haveEntityParam) {
                    throw new ClientRuntimeException("two non-annotated params not allowed, parameter #" + i);
                }
                args[i] = cr.getEntity(parameterTypes[i]);
                haveEntityParam = true;
                continue;
            }
            boolean isRequired = ArgumentInjector.hasRequiredAnnotation(annotations);
            Annotation selectorAnnotation = ArgumentInjector.getSelectorAnnotation(annotations);
            if (selectorAnnotation == null) {
                throw new ClientRuntimeException("missing/unrecognized selector annotation on parameter #" + i);
            }
            if (selectorAnnotation.annotationType() == HeaderParam.class) {
                String headerValue = (String)cr.getHeaders().getFirst((Object)((HeaderParam)selectorAnnotation).value());
                if (isRequired && headerValue == null) {
                    throw new ClientRuntimeException("required header " + ((HeaderParam)selectorAnnotation).value() + "not present.");
                }
                if (headerValue == null) {
                    args[i] = null;
                    continue;
                }
                if (parameterTypes[i] == String.class) {
                    args[i] = headerValue;
                    continue;
                }
                if (parameterTypes[i] == URI.class) {
                    args[i] = URI.create(headerValue);
                    continue;
                }
                if (parameterTypes[i] == ViewResource.class) {
                    args[i] = client.viewResource(headerValue);
                    continue;
                }
                if (parameterTypes[i] == WebResource.class) {
                    args[i] = client.resource(headerValue);
                    continue;
                }
                throw new ClientRuntimeException("Cannot inject this header as this type.");
            }
            if (selectorAnnotation.annotationType() == Context.class) {
                if (parameterTypes[i] == Client.class) {
                    args[i] = client;
                    continue;
                }
                if (parameterTypes[i] == ClientResponse.class) {
                    args[i] = cr;
                    responseOrOutputStreamInjected = true;
                    continue;
                }
                if (parameterTypes[i] == InputStream.class) {
                    args[i] = cr.getEntityInputStream();
                    responseOrOutputStreamInjected = true;
                    continue;
                }
                if (parameterTypes[i] == URI.class) {
                    if (uri != null) {
                        args[i] = uri;
                        continue;
                    }
                    throw new ClientRuntimeException("Request URI cannot be injected in this context.");
                }
                if (parameterTypes[i] == ViewResource.class) {
                    if (uri != null) {
                        args[i] = client.viewResource(uri);
                        continue;
                    }
                    throw new ClientRuntimeException("ViewResource based on request URI cannot be injected in this context.");
                }
                if (parameterTypes[i] == WebResourceLinkHeaders.class) {
                    args[i] = cr.getLinks();
                    continue;
                }
                throw new ClientRuntimeException("Unrecognized parameter type " + parameterTypes[i].getName() + " for @Context annotation in parameter at index " + i);
            }
            throw new ClientRuntimeException("Unsupported selector annotation on parameter #" + i);
        }
        return args;
    }

    static boolean hasRequiredAnnotation(Annotation[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].annotationType() != Required.class) continue;
            return true;
        }
        return false;
    }

    static Annotation getSelectorAnnotation(Annotation[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].annotationType() == Context.class) {
                return a[i];
            }
            if (a[i].annotationType() != HeaderParam.class) continue;
            return a[i];
        }
        return null;
    }
}

