/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.view.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.client.view.annotation.Status;
import com.sun.jersey.client.view.client.ViewModel;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;

public class ViewModelMatcher {
    public static <T extends Annotation> AnnotatedMethod findMethod(ViewModel viewModel, String httpMethod, ClientResponse cr) {
        MethodList methodList = viewModel.getMethodsForHttpMethod(httpMethod);
        for (AnnotatedMethod method : methodList) {
            MediaType contentType;
            System.out.println("Checked Method: " + method.getMethod().getName());
            if (!ViewModelMatcher.isStatusMatch(method, cr.getStatus()) || (contentType = cr.getType()) != null && !ViewModelMatcher.isMediaTypeMatch(MediaTypes.createMediaTypes((String[])((Consumes)method.getAnnotation(Consumes.class)).value()), contentType)) continue;
            return method;
        }
        return null;
    }

    private static boolean isStatusMatch(AnnotatedMethod method, int status) {
        if (!method.isAnnotationPresent(Status.class)) {
            return true;
        }
        Status s = (Status)method.getAnnotation(Status.class);
        for (int value : s.value()) {
            if (value != status) continue;
            return true;
        }
        return false;
    }

    private static boolean isMediaTypeMatch(List<MediaType> consumes, MediaType contentType) {
        for (MediaType mt : consumes) {
            if (!mt.isCompatible(contentType)) continue;
            return true;
        }
        return false;
    }
}

