/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.view.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.AsyncClientHandler;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.client.impl.async.FutureClientResponseListener;
import com.sun.jersey.client.proxy.ViewProxy;
import com.sun.jersey.client.proxy.ViewProxyProvider;
import com.sun.jersey.client.view.client.ArgumentInjector;
import com.sun.jersey.client.view.client.ViewModel;
import com.sun.jersey.client.view.client.ViewModelMatcher;
import com.sun.jersey.client.view.client.ViewModeller;
import com.sun.jersey.client.view.exception.ClientErrorException;
import com.sun.jersey.client.view.exception.ClientRuntimeException;
import com.sun.jersey.client.view.exception.ResponseNotHandledByViewException;
import com.sun.jersey.client.view.exception.ServerErrorException;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;

public class ViewImplProxyProvider
implements ViewProxyProvider {
    public <T> ViewProxy<T> proxy(final Client client, Class<T> ctlr) {
        return new ViewProxy<T>(){

            private void invoke(Method m, Object o, Object[] params) {
                try {
                    m.invoke(o, params);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof RuntimeException) {
                        throw (RuntimeException)target;
                    }
                    throw new ClientRuntimeException(target);
                }
                catch (Exception e) {
                    throw new ClientRuntimeException(e);
                }
            }

            private T getInstance(Class<T> type) {
                try {
                    Constructor c = type.getConstructor(new Class[0]);
                    return c.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new ClientRuntimeException(e);
                }
            }

            private void processRequest(ViewModel viewModel, ClientRequest request) {
                String[] consumes = viewModel.getConsumesFor(request.getMethod());
                if (consumes.length > 0) {
                    request.getHeaders().remove((Object)"Accept");
                    for (String consume : consumes) {
                        request.getHeaders().add((Object)"Accept", (Object)consume);
                    }
                }
            }

            private T processResponse(ViewModel viewModel, T v, ClientRequest request, ClientResponse response) {
                AnnotatedMethod m = ViewModelMatcher.findMethod(viewModel, request.getMethod(), response);
                if (m == null) {
                    if (response.getClientResponseStatus().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                        throw new ClientErrorException(response);
                    }
                    if (response.getClientResponseStatus().getFamily() == Response.Status.Family.SERVER_ERROR) {
                        throw new ServerErrorException(response);
                    }
                    throw new ResponseNotHandledByViewException(response);
                }
                Object[] args = ArgumentInjector.makeArgs(client, m, response, request.getMethod().equals("GET") ? request.getURI() : null);
                this.invoke(m.getMethod(), v, args);
                return v;
            }

            public T view(Class<T> type, ClientRequest request, ClientHandler handler) {
                return this.view(this.getInstance(type), request, handler);
            }

            public T view(T v, ClientRequest request, ClientHandler handler) {
                ViewModel viewModel = ViewModeller.createViewModel(v.getClass());
                this.processRequest(viewModel, request);
                ClientResponse response = handler.handle(request);
                return this.processResponse(viewModel, v, request, response);
            }

            public Future<T> asyncView(Class<T> type, ClientRequest request, AsyncClientHandler handler) {
                return this.asyncView(this.getInstance(type), request, handler);
            }

            public Future<T> asyncView(final T v, final ClientRequest request, AsyncClientHandler handler) {
                final ViewModel viewModel = ViewModeller.createViewModel(v.getClass());
                this.processRequest(viewModel, request);
                FutureClientResponseListener ftw = new FutureClientResponseListener<T>(){

                    protected T get(ClientResponse response) {
                        return this.processResponse(viewModel, v, request, response);
                    }
                };
                ftw.setCancelableFuture(handler.handle(request, (FutureListener)ftw));
                return ftw;
            }

            public T view(Class<T> type, ClientResponse response) {
                return this.view(this.getInstance(type), response);
            }

            public T view(T v, ClientResponse cr) {
                ViewModel viewModel = ViewModeller.createViewModel(v.getClass());
                AnnotatedMethod m = ViewModelMatcher.findMethod(viewModel, "GET", cr);
                if (m == null) {
                    if (cr.getClientResponseStatus().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                        throw new ClientErrorException(cr);
                    }
                    if (cr.getClientResponseStatus().getFamily() == Response.Status.Family.SERVER_ERROR) {
                        throw new ServerErrorException(cr);
                    }
                    throw new ResponseNotHandledByViewException(cr);
                }
                Object[] args = ArgumentInjector.makeArgs(client, m, cr, null);
                this.invoke(m.getMethod(), v, args);
                return v;
            }
        };
    }
}

