/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.proxy;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.client.proxy.ClientResponseProxy;
import com.sun.jersey.client.proxy.MultivaluedHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public final class WebResourceFactory
implements InvocationHandler {
    private final WebResource resource;
    private final UriBuilder uriBuilder;
    private final MultivaluedMap<String, Object> headers;
    private final Map<String, Cookie> cookies;
    private final Map<String, Object> pathParams;
    private final Form form;

    public static <C> C newResource(Class<C> resourceInterface, WebResource resource) {
        return WebResourceFactory.newResource(resourceInterface, resource, null, new MultivaluedHashMap<String, Object>(), new HashMap<String, Cookie>(), new HashMap<String, Object>(), new Form());
    }

    static <C> C newResource(Class<C> resourceInterface, WebResource resource, UriBuilder uriBuilder, MultivaluedMap<String, Object> headers, Map<String, Cookie> cookies, Map<String, Object> pathParams, Form form) {
        return (C)Proxy.newProxyInstance(resourceInterface.getClassLoader(), new Class[]{resourceInterface}, (InvocationHandler)new WebResourceFactory(resource, uriBuilder != null ? uriBuilder : WebResourceFactory.addPathFromAnnotation(resourceInterface, resource.getUriBuilder()), headers, cookies, pathParams, form));
    }

    private WebResourceFactory(WebResource resource, UriBuilder uriBuilder, MultivaluedMap<String, Object> headers, Map<String, Cookie> cookies, Map<String, Object> pathParams, Form form) {
        this.resource = resource;
        this.uriBuilder = uriBuilder == null ? resource.getUriBuilder() : uriBuilder;
        this.cookies = cookies;
        this.form = form;
        this.headers = headers;
        this.pathParams = pathParams;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        GenericType responseGenericType;
        Class<?> proxyIfc = proxy.getClass().getInterfaces()[0];
        Class<Object> responseType = method.getReturnType();
        String httpMethod = WebResourceFactory.getHttpMethodName(method);
        if (httpMethod == null) {
            Annotation ann;
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (httpMethod = WebResourceFactory.getHttpMethodName((ann = annotationArray[i]).annotationType())) == null; ++i) {
            }
        }
        UriBuilder backupBuilder = this.uriBuilder.clone();
        UriBuilder uriBuilder = WebResourceFactory.addPathFromAnnotation(method, backupBuilder);
        if (httpMethod == null) {
            if (uriBuilder == null) {
                throw new UnsupportedOperationException("Not a resource method.");
            }
            if (!responseType.isInterface()) {
                throw new UnsupportedOperationException("Return type not an interface");
            }
        }
        if (uriBuilder == null) {
            uriBuilder = backupBuilder;
        }
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>(this.headers);
        HashMap<String, Object> pathParams = new HashMap<String, Object>(this.pathParams);
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>(this.cookies);
        Form form = new Form();
        form.putAll((Map)this.form);
        Annotation[][] paramAnns = method.getParameterAnnotations();
        Object entity = null;
        Type entityType = null;
        for (int i = 0; i < paramAnns.length; ++i) {
            Annotation ann;
            HashMap<Class<? extends Annotation>, Annotation> anns = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation ann2 : paramAnns[i]) {
                anns.put(ann2.annotationType(), ann2);
            }
            Object value = args[i];
            if (anns.isEmpty()) {
                entityType = method.getGenericParameterTypes()[i];
                entity = value;
                continue;
            }
            if (value == null && (ann = (Annotation)anns.get(DefaultValue.class)) != null) {
                value = ((DefaultValue)ann).value();
            }
            if (value == null) continue;
            ann = (Annotation)anns.get(PathParam.class);
            if (ann != null) {
                pathParams.put(((PathParam)ann).value(), value);
                continue;
            }
            ann = (Annotation)anns.get(QueryParam.class);
            if (ann != null) {
                uriBuilder.queryParam(((QueryParam)ann).value(), new Object[]{value});
                continue;
            }
            ann = (Annotation)anns.get(HeaderParam.class);
            if (ann != null) {
                headers.add(((HeaderParam)ann).value(), value);
                continue;
            }
            ann = (Annotation)anns.get(CookieParam.class);
            if (ann != null) {
                Cookie c;
                String name = ((CookieParam)ann).value();
                if (!(value instanceof Cookie)) {
                    c = new Cookie(name, value.toString());
                } else {
                    c = (Cookie)value;
                    if (!name.equals(((Cookie)value).getName())) {
                        c = new Cookie(name, c.getValue(), c.getPath(), c.getDomain(), c.getVersion());
                    }
                }
                cookies.put(name, c);
                continue;
            }
            ann = (Annotation)anns.get(MatrixParam.class);
            if (ann != null) {
                uriBuilder.matrixParam(((MatrixParam)ann).value(), new Object[]{value});
                continue;
            }
            ann = (Annotation)anns.get(FormParam.class);
            if (ann == null) continue;
            form.add(((FormParam)ann).value(), value.toString());
        }
        if (httpMethod == null) {
            return WebResourceFactory.newResource(responseType, this.resource, uriBuilder, headers, cookies, pathParams, form);
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces == null) {
            produces = proxyIfc.getAnnotation(Produces.class);
        }
        String[] accepts = produces == null ? null : produces.value();
        String contentType = null;
        if (entity != null) {
            Consumes consumes = method.getAnnotation(Consumes.class);
            if (consumes == null) {
                consumes = proxyIfc.getAnnotation(Consumes.class);
            }
            if (consumes != null && consumes.value().length > 0) {
                contentType = consumes.value()[0];
            }
        }
        WebResource.Builder b = this.resource.uri(uriBuilder.buildFromMap(pathParams)).getRequestBuilder();
        for (Cookie c : cookies.values()) {
            b.cookie(c);
        }
        for (Map.Entry header : headers.entrySet()) {
            for (Object value : (List)header.getValue()) {
                b = (WebResource.Builder)b.header((String)header.getKey(), value);
            }
        }
        if (accepts != null) {
            b.accept(accepts);
        }
        if (entity == null && !form.isEmpty()) {
            entity = form;
            contentType = "application/x-www-form-urlencoded";
        } else {
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if (!form.isEmpty() && entity instanceof Form) {
                ((Form)entity).putAll((Map)form);
            }
        }
        if (Response.class.isAssignableFrom(responseType)) {
            responseType = ClientResponse.class;
            responseGenericType = new GenericType(ClientResponse.class);
        } else {
            responseGenericType = new GenericType(method.getGenericReturnType());
        }
        if (entity != null) {
            if (entityType instanceof ParameterizedType) {
                entity = new GenericEntity(entity, entityType);
            }
            result = ((WebResource.Builder)b.type(contentType)).method(httpMethod, responseGenericType, entity);
        } else {
            result = b.method(httpMethod, responseGenericType);
        }
        if (responseType == ClientResponse.class) {
            result = new ClientResponseProxy((ClientResponse)result);
        }
        return result;
    }

    private static UriBuilder addPathFromAnnotation(AnnotatedElement ae, UriBuilder uriBuilder) {
        Path p = ae.getAnnotation(Path.class);
        if (p != null) {
            return uriBuilder.path(p.value());
        }
        return null;
    }

    private static String getHttpMethodName(AnnotatedElement ae) {
        HttpMethod a = ae.getAnnotation(HttpMethod.class);
        return a == null ? null : a.value();
    }
}

