/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.hypermedia.filter;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.core.header.LinkHeader;
import com.sun.jersey.core.hypermedia.Action;
import com.sun.jersey.core.hypermedia.ContextualActionSet;
import com.sun.jersey.core.hypermedia.HypermediaController;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class HypermediaFilterFactory
implements ResourceFilterFactory {
    private final UriInfo uriInfo;

    public HypermediaFilterFactory(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<ResourceFilter> create(AbstractMethod am) {
        AbstractResource ar = am.getResource();
        HypermediaController ctrl = (HypermediaController)ar.getAnnotation(HypermediaController.class);
        if (ctrl != null) {
            if (ctrl.linkType() != HypermediaController.LinkType.LINK_HEADERS) {
                throw new RuntimeException("Unsupported hypermedia link type " + ctrl.linkType().name());
            }
            if (am.getMethod().getReturnType() == ctrl.model() || am.isAnnotationPresent(Action.class)) {
                ArrayList<ResourceFilter> result = new ArrayList<ResourceFilter>(1);
                result.add(new HypermediaFilter(am));
                return result;
            }
        }
        return null;
    }

    private class HypermediaFilter
    implements ResourceFilter,
    ContainerResponseFilter,
    ContainerRequestFilter {
        private AbstractMethod abstractMethod;
        private Method contextualActionSetMethod;
        private Map<String, AbstractResourceMethod> actionMethods;

        public HypermediaFilter(AbstractMethod abstractMethod) {
            this.abstractMethod = abstractMethod;
            this.actionMethods = new HashMap<String, AbstractResourceMethod>();
            this.prepare();
        }

        private void prepare() {
            AbstractResource ar = this.abstractMethod.getResource();
            List<Method> methods = this.getContextualActionSetMethods(ar);
            if (!methods.isEmpty()) {
                this.contextualActionSetMethod = methods.get(0);
            }
            for (AbstractResourceMethod m : ar.getSubResourceMethods()) {
                Action action = (Action)m.getAnnotation(Action.class);
                if (action == null) continue;
                this.actionMethods.put(action.value(), m);
            }
        }

        private List<Method> getContextualActionSetMethods(AbstractResource resource) {
            MethodList methodList = new MethodList(resource.getResourceClass(), true);
            ArrayList<Method> contextualActionSetMethods = new ArrayList<Method>();
            for (AnnotatedMethod m : methodList.hasAnnotation(ContextualActionSet.class).hasNumParams(0).hasReturnType(Set.class)) {
                AccessController.doPrivileged(ReflectionHelper.setAccessibleMethodPA((Method)m.getMethod()));
                contextualActionSetMethods.add(m.getMethod());
            }
            return contextualActionSetMethods;
        }

        public ContainerRequestFilter getRequestFilter() {
            return this;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            Object resourceInstance = HypermediaFilterFactory.this.uriInfo.getMatchedResources().get(0);
            if (request.isTracingEnabled()) {
                request.trace("HypermediaFilter called for response; resourceInstance = " + resourceInstance);
            }
            Set actionSet = null;
            if (this.contextualActionSetMethod != null) {
                try {
                    actionSet = (Set)this.contextualActionSetMethod.invoke(resourceInstance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (actionSet == null) {
                actionSet = this.actionMethods.keySet();
            }
            if (actionSet != null) {
                for (String action : actionSet) {
                    AbstractResourceMethod rm = this.actionMethods.get(action);
                    if (rm == null) {
                        throw new RuntimeException("Contextual action set returned by resource " + resourceInstance + "is not sound");
                    }
                    String uri = HypermediaFilterFactory.this.uriInfo.getRequestUri().toString();
                    if (this.abstractMethod.isAnnotationPresent(Action.class)) {
                        Path path = (Path)this.abstractMethod.getAnnotation(Path.class);
                        int k = uri.lastIndexOf(path.value());
                        assert (k > 0);
                        uri = uri.substring(0, k);
                    }
                    UriBuilder uriBuilder = UriBuilder.fromUri((String)uri);
                    LinkHeader lh = LinkHeader.uri((URI)uriBuilder.path(rm.getMethod()).build(new Object[0])).rel(action).op(rm.getHttpMethod()).build();
                    response.getHttpHeaders().add((Object)"Link", (Object)lh);
                }
            }
            return response;
        }

        public ContainerRequest filter(ContainerRequest request) {
            Action action;
            Object resourceInstance = HypermediaFilterFactory.this.uriInfo.getMatchedResources().get(0);
            if (request.isTracingEnabled()) {
                request.trace("HypermediaFilter called for request; resourceInstance = " + resourceInstance);
            }
            if ((action = (Action)this.abstractMethod.getAnnotation(Action.class)) == null) {
                return request;
            }
            Set actionSet = null;
            if (this.contextualActionSetMethod != null) {
                try {
                    actionSet = (Set)this.contextualActionSetMethod.invoke(resourceInstance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (actionSet != null && !actionSet.contains(action.value())) {
                throw new RuntimeException("Action '" + action.value() + "' is not in contextual action set returned by " + resourceInstance);
            }
            return request;
        }
    }
}

