/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.hypermedia;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.async.AsyncClientHandler;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.client.hypermedia.ControllerInvocationHandler;
import com.sun.jersey.client.impl.async.FutureClientResponseListener;
import com.sun.jersey.client.proxy.ViewProxy;
import com.sun.jersey.client.proxy.ViewProxyProvider;
import com.sun.jersey.core.hypermedia.HypermediaController;
import java.lang.reflect.Proxy;
import java.util.concurrent.Future;

public class HypermediaViewProxyProvider
implements ViewProxyProvider {
    public <T> ViewProxy<T> proxy(final Client client, final Class<T> ctlr) {
        if (!ctlr.isAnnotationPresent(HypermediaController.class)) {
            return null;
        }
        return new ViewProxy<T>(){

            private T process(ClientRequest request, ClientResponse response) {
                Object instance;
                HypermediaController ctrl = ctlr.getAnnotation(HypermediaController.class);
                Class c = ctrl.model();
                if (c == ClientResponse.class) {
                    instance = c.cast(response);
                } else if (response.getStatus() < 300) {
                    instance = response.getEntity(c);
                } else {
                    throw new UniformInterfaceException(response, request.getPropertyAsFeature("com.sun.jersey.client.property.bufferResponseEntityOnException", true));
                }
                return Proxy.newProxyInstance(ctlr.getClassLoader(), new Class[]{ctlr}, new ControllerInvocationHandler(client, instance, response, ctlr));
            }

            public T view(Class<T> type, ClientRequest request, ClientHandler handler) {
                ClientResponse response = handler.handle(request);
                return this.process(request, response);
            }

            public T view(T v, ClientRequest request, ClientHandler handler) {
                throw new UnsupportedOperationException();
            }

            public Future<T> asyncView(Class<T> type, final ClientRequest request, AsyncClientHandler handler) {
                FutureClientResponseListener ftw = new FutureClientResponseListener<T>(){

                    protected T get(ClientResponse response) {
                        return this.process(request, response);
                    }
                };
                ftw.setCancelableFuture(handler.handle(request, (FutureListener)ftw));
                return ftw;
            }

            public Future<T> asyncView(T v, ClientRequest request, AsyncClientHandler handler) {
                throw new UnsupportedOperationException();
            }

            public T view(Class<T> type, ClientResponse response) {
                throw new UnsupportedOperationException();
            }

            public T view(T v, ClientResponse cr) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

