/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.hypermedia;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.WebResourceLinkHeaders;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.header.LinkHeader;
import com.sun.jersey.core.hypermedia.Action;
import com.sun.jersey.core.hypermedia.HypermediaController;
import com.sun.jersey.core.hypermedia.Name;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl2java.Wadl2Java;
import org.jvnet.ws.wadl2java.ast.MethodNode;
import org.jvnet.ws.wadl2java.ast.RepresentationNode;
import org.jvnet.ws.wadl2java.ast.ResourceNode;

public class ControllerInvocationHandler<T>
implements InvocationHandler {
    private Client client;
    private T model;
    private Class<?> modelClass;
    private Class<?> ctrlClass;
    private ClientResponse response;
    private WebResourceLinkHeaders actionHeaders;
    private Object entity;
    private MultivaluedMapImpl queryParams;
    private Map<URI, MethodNode> wadlMetadataCache;

    public ControllerInvocationHandler(Client client, T instance, ClientResponse response, Class<?> ctrlClass) {
        if (!ctrlClass.isAnnotationPresent(HypermediaController.class)) {
            throw new IllegalArgumentException("Hypermedia controller class must have @HypermediaController annotation");
        }
        this.client = client;
        this.model = instance;
        this.response = response;
        this.modelClass = instance.getClass();
        this.ctrlClass = ctrlClass;
        this.updateActionHeaders();
        this.queryParams = new MultivaluedMapImpl();
    }

    @Override
    public Object invoke(Object o, Method method, Object[] params) throws Throwable {
        this.entity = null;
        this.queryParams.clear();
        Action action = method.getAnnotation(Action.class);
        if (action == null && method.getReturnType() == this.modelClass) {
            return this.model;
        }
        if (action == null) {
            throw new RuntimeException("Method " + method.getName() + " in " + o.getClass().getInterfaces()[0].getName() + " must have @Action or @Model annotation");
        }
        if (this.actionHeaders == null) {
            throw new RuntimeException("Action '" + action.value() + "' is not available in current context");
        }
        LinkHeader h = this.actionHeaders.getLink(action.value());
        if (h == null) {
            throw new RuntimeException("Action '" + action.value() + "' is not available in current context");
        }
        String httpMethod = this.getHttpMethod(this.ctrlClass, method);
        if (httpMethod == null) {
            httpMethod = h.getOp();
            assert (httpMethod != null);
        } else if (!httpMethod.equals(h.getOp())) {
            throw new RuntimeException("HTTP method annotation " + httpMethod + " in method '" + method.getName() + "' does not match HTTP method " + h.getOp() + " in link header");
        }
        ClientRequest.Builder rb = ClientRequest.create();
        this.mapParametersToClientRequest(rb, method, params);
        UriBuilder ub = UriBuilder.fromUri((URI)h.getUri());
        for (Map.Entry e : this.queryParams.entrySet()) {
            for (String v : (List)e.getValue()) {
                ub.queryParam((String)e.getKey(), new Object[]{v});
            }
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces != null) {
            rb.accept(produces.value());
        }
        if (this.entity != null) {
            String contentType = null;
            Consumes consumes = method.getAnnotation(Consumes.class);
            if (consumes != null) {
                String[] contentTypes = consumes.value();
                if (contentTypes.length > 1) {
                    throw new RuntimeException("Annotation @Consumes in action '" + action.value() + " ' must have a single media type");
                }
                contentType = contentTypes[0];
            } else if (this.entity instanceof MultivaluedMap) {
                contentType = "application/x-www-form-urlencoded";
            } else {
                contentType = this.getContentTypeFromWadl(action, method);
                assert (contentType != null);
            }
            ClientRequest cr = ((ClientRequest.Builder)rb.entity(this.entity, contentType)).build(ub.build(new Object[0]), httpMethod);
            this.response = this.client.handle(cr);
        } else {
            ClientRequest cr = rb.build(ub.build(new Object[0]), httpMethod);
            this.response = this.client.handle(cr);
        }
        this.updateActionHeaders();
        HypermediaController hc = this.ctrlClass.getAnnotation(HypermediaController.class);
        assert (hc != null);
        if (method.getReturnType() == hc.model()) {
            this.model = this.response.getEntity(this.modelClass);
            this.response.close();
            return this.model;
        }
        if (method.getReturnType() != Void.TYPE) {
            Object tmp = this.response.getEntity(method.getReturnType());
            this.response.close();
            return tmp;
        }
        return null;
    }

    private void updateActionHeaders() {
        this.actionHeaders = this.response.getLinks();
    }

    private String getHttpMethod(Class<?> ctrlClass, Method method) {
        Class<?>[] superInterfaces;
        for (Annotation annot : method.getDeclaredAnnotations()) {
            HttpMethod httpMethod = annot.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod.value();
        }
        for (Class<?> superInterface : superInterfaces = ctrlClass.getInterfaces()) {
            for (Method superMethod : superInterface.getDeclaredMethods()) {
                if (!superMethod.getName().equals(method.getName()) || superMethod.getReturnType() != method.getReturnType() || !Arrays.equals(superMethod.getParameterTypes(), method.getParameterTypes())) continue;
                return this.getHttpMethod(superInterface, superMethod);
            }
        }
        return null;
    }

    private boolean isJaxrsCollectionValue(Object object) {
        return object instanceof List || object instanceof Set || object instanceof SortedSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapParametersToClientRequest(ClientRequest.Builder rb, Method method, Object[] values) {
        if (values == null) return;
        Annotation[][] annotations = method.getParameterAnnotations();
        int j = 0;
        for (Object value : values) {
            if (annotations[j++].length != 0) continue;
            this.entity = value;
            break;
        }
        j = 0;
        for (Object value : values) {
            if (annotations[j].length > 1) {
                throw new IllegalArgumentException("At most one annotation is permitted in method '" + method.getName() + "' of interface '" + this.ctrlClass.getName() + "'");
            }
            for (Annotation annot : annotations[j]) {
                Class<? extends Annotation> paramType = annot.annotationType();
                if (paramType == Name.class) {
                    this.mapParamUsingWadl(method, (Name)annot, value, rb);
                    continue;
                }
                if (paramType == HeaderParam.class) {
                    HeaderParam hp = (HeaderParam)annot;
                    this.setHeaderParam(hp.value(), value, rb);
                    continue;
                }
                if (paramType == QueryParam.class) {
                    QueryParam qp = (QueryParam)annot;
                    this.setQueryParam(qp.value(), value);
                    continue;
                }
                if (paramType == CookieParam.class) {
                    this.setCookieParam(value, rb);
                    continue;
                }
                if (paramType != FormParam.class) throw new IllegalArgumentException("Annotation " + paramType.getName() + " is not permitted in interface '" + this.ctrlClass.getName() + "'");
                Form form = null;
                FormParam fp = (FormParam)annot;
                if (this.entity != null) {
                    if (!(this.entity instanceof Form) && !(this.entity instanceof MultivaluedMap)) throw new IllegalArgumentException("Unannotated parameter in method '" + method.getName() + "' in interface '" + this.ctrlClass.getName() + "' must be an instance of Form or  MultivaluedMap to support @FormParam");
                    form = (MultivaluedMap)this.entity;
                } else {
                    form = new Form();
                    this.entity = form;
                }
                this.setFormParam(fp.value(), value, (MultivaluedMap)form);
            }
            ++j;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapParamUsingWadl(Method method, Name name, Object value, ClientRequest.Builder rb) {
        List reps;
        String paramName;
        Action action = method.getAnnotation(Action.class);
        LinkHeader h = this.actionHeaders.getLink(action.value());
        MethodNode methodNode = this.getWadlMetadata(h);
        if (methodNode == null) {
            throw new RuntimeException("Unable to find WADL meta-data to map hypermedia action '" + action.value() + "'");
        }
        List params = methodNode.getQueryParameters();
        if (params != null) {
            for (Param param : params) {
                paramName = param.getName();
                if (!paramName.equals(name.value())) continue;
                this.setQueryParam(paramName, value);
                return;
            }
        }
        if ((params = methodNode.getHeaderParameters()) != null) {
            for (Param param : params) {
                paramName = param.getName();
                if (paramName.equals(name.value())) {
                    this.setHeaderParam(paramName, value, rb);
                    return;
                }
                if (!paramName.equals("Cookie") || !param.getPath().equals(name.value())) continue;
                this.setCookieParam(value, rb);
                return;
            }
        }
        if ((reps = methodNode.getSupportedInputs()) == null) throw new RuntimeException("Unable to map parameter '" + name.value() + "' in method '" + method.getName() + "' of interface '" + this.ctrlClass.getName() + "'");
        for (RepresentationNode rep : reps) {
            for (Param param : rep.getParam()) {
                if (!param.getName().equals(name.value())) continue;
                Form form = null;
                if (this.entity != null) {
                    if (!(this.entity instanceof Form) && !(this.entity instanceof MultivaluedMap)) throw new IllegalArgumentException("Unannotated parameter in method '" + method.getName() + "' in interface '" + this.ctrlClass.getName() + "' must be an instance of Form or  MultivaluedMap to support @FormParam");
                    form = (MultivaluedMap)this.entity;
                } else {
                    form = new Form();
                    this.entity = form;
                }
                this.setFormParam(name.value(), value, (MultivaluedMap)form);
                return;
            }
        }
        throw new RuntimeException("Unable to map parameter '" + name.value() + "' in method '" + method.getName() + "' of interface '" + this.ctrlClass.getName() + "'");
    }

    private String getContentTypeFromWadl(Action action, Method method) {
        LinkHeader h = this.actionHeaders.getLink(action.value());
        MethodNode methodNode = this.getWadlMetadata(h);
        if (methodNode == null) {
            throw new RuntimeException("Unable to find WADL meta-data to map hypermedia action '" + action.value() + "'");
        }
        List l = methodNode.getSupportedInputs();
        if (l == null || l.size() > 1) {
            throw new RuntimeException("Unable to determine content type for action '" + action.value() + "' -- use @Consumes annotation");
        }
        return ((RepresentationNode)l.get(0)).getMediaType();
    }

    private MethodNode getWadlMetadata(LinkHeader h) {
        MethodNode result = null;
        if (this.wadlMetadataCache == null) {
            this.wadlMetadataCache = new HashMap<URI, MethodNode>();
        } else {
            result = this.wadlMetadataCache.get(h.getUri());
        }
        if (result == null) {
            Wadl2Java wm = new Wadl2Java(null, null, null, false);
            try {
                WebResource r = this.client.resource(h.getUri());
                InputStream is = (InputStream)r.options(InputStream.class);
                Application a = wm.processDescription(h.getUri(), is);
                List rs = wm.buildAst(a, h.getUri());
                ResourceNode rn = (ResourceNode)((ResourceNode)rs.get(0)).getChildResources().get(0);
                for (MethodNode mn : rn.getMethods()) {
                    if (!mn.getName().equals(h.getOp())) continue;
                    result = mn;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.wadlMetadataCache.put(h.getUri(), result);
        }
        return result;
    }

    private void setQueryParam(String name, Object value) {
        if (this.isJaxrsCollectionValue(value)) {
            for (Object o : (Collection)value) {
                this.queryParams.add(name, o.toString());
            }
        } else {
            this.queryParams.add(name, value.toString());
        }
    }

    private void setHeaderParam(String name, Object value, ClientRequest.Builder rb) {
        if (this.isJaxrsCollectionValue(value)) {
            for (Object o : (Collection)value) {
                rb.header(name, o);
            }
        } else {
            rb.header(name, value);
        }
    }

    private void setCookieParam(Object value, ClientRequest.Builder rb) {
        if (this.isJaxrsCollectionValue(value)) {
            for (Object o : (Collection)value) {
                rb.cookie(o instanceof Cookie ? (Cookie)o : Cookie.valueOf((String)o.toString()));
            }
        } else {
            rb.cookie(value instanceof Cookie ? (Cookie)value : Cookie.valueOf((String)value.toString()));
        }
    }

    private void setFormParam(String name, Object value, MultivaluedMap form) {
        if (this.isJaxrsCollectionValue(value)) {
            for (Object o : (Collection)value) {
                form.add((Object)name, o);
            }
        } else {
            form.add((Object)name, value);
        }
    }
}

