/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.simple.container;

import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.SocketConnection;

public final class SimpleServerFactory {
    private SimpleServerFactory() {
    }

    public static Closeable create(String address) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address));
    }

    public static Closeable create(String address, SSLContext context) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), context);
    }

    public static Closeable create(URI address) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, (Container)ContainerFactory.createContainer(Container.class));
    }

    public static Closeable create(URI address, SSLContext context) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, context, (Container)ContainerFactory.createContainer(Container.class));
    }

    public static Closeable create(String address, ResourceConfig config) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), config);
    }

    public static Closeable create(String address, SSLContext context, ResourceConfig config) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), context, config);
    }

    public static Closeable create(URI address, ResourceConfig config) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, (Container)ContainerFactory.createContainer(Container.class, (ResourceConfig)config));
    }

    public static Closeable create(URI address, SSLContext context, ResourceConfig config) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, context, (Container)ContainerFactory.createContainer(Container.class, (ResourceConfig)config));
    }

    public static Closeable create(String address, ResourceConfig config, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), config, factory);
    }

    public static Closeable create(String address, SSLContext context, ResourceConfig config, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), context, config, factory);
    }

    public static Closeable create(URI address, ResourceConfig config, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, (Container)ContainerFactory.createContainer(Container.class, (ResourceConfig)config, (IoCComponentProviderFactory)factory));
    }

    public static Closeable create(URI address, SSLContext context, ResourceConfig config, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        return SimpleServerFactory.create(address, context, (Container)ContainerFactory.createContainer(Container.class, (ResourceConfig)config, (IoCComponentProviderFactory)factory));
    }

    public static Closeable create(String address, Container container) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), container);
    }

    public static Closeable create(String address, SSLContext context, Container container) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(URI.create(address), context, container);
    }

    public static Closeable create(URI address, Container container) throws IOException, IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return SimpleServerFactory.create(address, null, container);
    }

    public static Closeable create(URI address, SSLContext context, Container container) throws IOException, IllegalArgumentException {
        int port;
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = address.getScheme();
        int defaultPort = 80;
        if (context == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException("The URI scheme should be 'http' when not using SSL");
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException("The URI scheme should be 'https' when using SSL");
            }
            defaultPort = 143;
        }
        if ((port = address.getPort()) == -1) {
            port = defaultPort;
        }
        InetSocketAddress listen = new InetSocketAddress(port);
        SocketConnection connection = new SocketConnection(container);
        connection.connect((SocketAddress)listen, context);
        return connection;
    }
}

