/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.CommittingOutputStream;
import com.sun.jersey.api.client.RequestWriter;
import com.sun.jersey.client.apache.ApacheHttpMethodExecutor;
import com.sun.jersey.client.apache.config.ApacheHttpClientState;
import com.sun.jersey.client.apache.config.DefaultCredentialsProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class DefaultApacheHttpMethodExecutor
extends RequestWriter
implements ApacheHttpMethodExecutor {
    private static final DefaultCredentialsProvider DEFAULT_CREDENTIALS_PROVIDER = new DefaultCredentialsProvider();
    private final HttpClient httpClient;

    public DefaultApacheHttpMethodExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void executeMethod(final HttpMethod method, final ClientRequest cr) {
        Map props = cr.getProperties();
        method.setDoAuthentication(true);
        HttpMethodParams methodParams = method.getParams();
        if (!cr.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.handleCookies")) {
            methodParams.setCookiePolicy("ignoreCookies");
        }
        if (cr.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.interactive")) {
            CredentialsProvider provider = (CredentialsProvider)props.get("com.sun.jersey.impl.client.httpclient.credentialsProvider");
            if (provider == null) {
                provider = DEFAULT_CREDENTIALS_PROVIDER;
            }
            methodParams.setParameter("http.authentication.credential-provider", (Object)provider);
        } else {
            methodParams.setParameter("http.authentication.credential-provider", null);
        }
        Integer readTimeout = (Integer)props.get("com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            methodParams.setSoTimeout(readTimeout.intValue());
        }
        if (method instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod entMethod = (EntityEnclosingMethod)method;
            if (cr.getEntity() != null) {
                final RequestWriter.RequestEntityWriter re = this.getRequestEntityWriter(cr);
                Integer chunkedEncodingSize = (Integer)props.get("com.sun.jersey.client.property.chunkedEncodingSize");
                if (chunkedEncodingSize != null) {
                    entMethod.setContentChunked(true);
                    this.writeOutBoundHeaders((MultivaluedMap<String, Object>)cr.getHeaders(), method);
                    entMethod.setRequestEntity(new RequestEntity(){

                        public boolean isRepeatable() {
                            return false;
                        }

                        public void writeRequest(OutputStream out) throws IOException {
                            re.writeRequestEntity(out);
                        }

                        public long getContentLength() {
                            return re.getSize();
                        }

                        public String getContentType() {
                            return re.getMediaType().toString();
                        }
                    });
                } else {
                    entMethod.setContentChunked(false);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        re.writeRequestEntity((OutputStream)new CommittingOutputStream(baos){

                            protected void commit() throws IOException {
                                DefaultApacheHttpMethodExecutor.this.writeOutBoundHeaders((MultivaluedMap<String, Object>)cr.getMetadata(), method);
                            }
                        });
                    }
                    catch (IOException ex) {
                        throw new ClientHandlerException((Throwable)ex);
                    }
                    final byte[] content = baos.toByteArray();
                    entMethod.setRequestEntity(new RequestEntity(){

                        public boolean isRepeatable() {
                            return true;
                        }

                        public void writeRequest(OutputStream out) throws IOException {
                            out.write(content);
                        }

                        public long getContentLength() {
                            return content.length;
                        }

                        public String getContentType() {
                            return re.getMediaType().toString();
                        }
                    });
                }
            }
        } else {
            this.writeOutBoundHeaders((MultivaluedMap<String, Object>)cr.getHeaders(), method);
            method.setFollowRedirects(cr.getPropertyAsFeature("com.sun.jersey.client.property.followRedirects"));
        }
        try {
            this.httpClient.executeMethod(this.getHostConfiguration(this.httpClient, props), method, this.getHttpState(props));
        }
        catch (Exception e) {
            method.releaseConnection();
            throw new ClientHandlerException((Throwable)e);
        }
    }

    private HttpState getHttpState(Map<String, Object> props) {
        ApacheHttpClientState httpState = (ApacheHttpClientState)props.get("com.sun.jersey.impl.client.httpclient.httpState");
        if (httpState != null) {
            return httpState.getHttpState();
        }
        return null;
    }

    private HostConfiguration getHostConfiguration(HttpClient client, Map<String, Object> props) {
        Object proxy = props.get("com.sun.jersey.impl.client.httpclient.proxyURI");
        if (proxy != null) {
            int proxyPort;
            URI proxyUri = this.getProxyUri(proxy);
            String proxyHost = proxyUri.getHost();
            if (proxyHost == null) {
                proxyHost = "localhost";
            }
            if ((proxyPort = proxyUri.getPort()) == -1) {
                proxyPort = 8080;
            }
            HostConfiguration hostConfig = new HostConfiguration(client.getHostConfiguration());
            String setHost = hostConfig.getProxyHost();
            int setPort = hostConfig.getProxyPort();
            if (setHost == null || !setHost.equals(proxyHost) || setPort == -1 || setPort != proxyPort) {
                hostConfig.setProxyHost(new ProxyHost(proxyHost, proxyPort));
            }
            return hostConfig;
        }
        return null;
    }

    private URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ClientHandlerException("The proxy URI property MUST be an instance of String or URI");
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, Object> metadata, HttpMethod method) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                method.setRequestHeader((String)e.getKey(), this.headerValueToString(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(this.headerValueToString(v));
            }
            method.setRequestHeader((String)e.getKey(), b.toString());
        }
    }
}

