/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClientHandler;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public class ApacheHttpClient
extends Client {
    private ApacheHttpClientHandler clientHandler;

    public ApacheHttpClient() {
        this(ApacheHttpClient.createDefaultClientHander(), (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root) {
        this(root, (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root, ClientConfig config, IoCComponentProviderFactory provider) {
        super((ClientHandler)root, config, provider);
        this.clientHandler = root;
        HttpClient client = root.getHttpClient();
        client.getParams().setAuthenticationPreemptive(config.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication"));
        Integer connectTimeout = (Integer)config.getProperty("com.sun.jersey.client.property.connectTimeout");
        if (connectTimeout != null) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeout.intValue());
        }
    }

    public ApacheHttpClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public static ApacheHttpClient create() {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander());
    }

    public static ApacheHttpClient create(ClientConfig cc) {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander(), cc);
    }

    public static ApacheHttpClient create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander(), cc, provider);
    }

    private static ApacheHttpClientHandler createDefaultClientHander() {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        return new ApacheHttpClientHandler(client);
    }
}

