/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.wadl;

import com.sun.jersey.api.core.ClasspathResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Resources;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class WadlGeneratorTask
extends Task {
    private Path classpath;
    private File wadlFile;
    private String baseUri;

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public File getDestfile() {
        return this.wadlFile;
    }

    public void setDestfile(File wadlFile) {
        this.wadlFile = wadlFile;
    }

    public String getbaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("The classpath is not defined");
        }
        if (this.wadlFile == null) {
            throw new BuildException("destfile attribute required", this.getLocation());
        }
        if (this.baseUri == null || this.baseUri.length() == 0) {
            throw new BuildException("baseUri attribute required", this.getLocation());
        }
        try {
            ApplicationDescription ad = this.createApplication(this.classpath.list());
            Application a = ad.getApplication();
            for (Resources resources : a.getResources()) {
                resources.setBase(this.baseUri);
            }
            JAXBContext c = JAXBContext.newInstance((String)"com.sun.research.ws.wadl", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Marshaller m = c.createMarshaller();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.wadlFile));
            try {
                m.marshal((Object)a, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
            File wadlChildren = new File(this.wadlFile.getPath() + "-/");
            wadlChildren.mkdirs();
            for (String key : ad.getExternalMetadataKeys()) {
                File nextFile = new File(wadlChildren, "key");
                ApplicationDescription.ExternalGrammar em = ad.getExternalGrammar(key);
                BufferedOutputStream out2 = new BufferedOutputStream(new FileOutputStream(nextFile));
                try {
                    ((OutputStream)out2).write(em.getContent());
                }
                finally {
                    ((OutputStream)out2).close();
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private ApplicationDescription createApplication(String[] paths) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Loader ncl = new Loader(this.classpath.list(), ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(ncl);
        try {
            ClasspathResourceConfig rc = new ClasspathResourceConfig(this.classpath.list());
            rc.validate();
            HashSet<AbstractResource> s = new HashSet<AbstractResource>();
            for (Class c : rc.getRootResourceClasses()) {
                s.add(IntrospectionModeller.createResource((Class)c));
            }
            ApplicationDescription applicationDescription = new WadlBuilder().generate(null, null, null, s);
            return applicationDescription;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static class Loader
    extends URLClassLoader {
        Loader(String[] paths, ClassLoader parent) {
            super(Loader.getURLs(paths), parent);
        }

        Loader(String[] paths) {
            super(Loader.getURLs(paths));
        }

        public Class findClass(String name) throws ClassNotFoundException {
            Class<?> c = super.findClass(name);
            return c;
        }

        private static URL[] getURLs(String[] paths) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            URL[] us = urls.toArray(new URL[0]);
            return us;
        }
    }
}

